/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.number;

import net.sf.saxon.z.IntRangeSet;

public class Alphanumeric {
    private static int[] zeroDigits = new int[]{48, 1632, 1776, 2406, 2534, 2662, 2790, 2918, 3046, 3174, 3302, 3430, 3664, 3792, 3872, 4160, 6112, 6160, 6470, 6608, 65296, 66720, 67534, 67544, 67554, 67564, 67574};
    private static int[] startPoints = new int[]{48, 65, 97, 170, 178, 181, 185, 188, 192, 216, 248, 592, 710, 736, 750, 890, 902, 904, 908, 910, 931, 976, 1015, 1162, 1232, 1280, 1329, 1369, 1377, 1488, 1520, 1569, 1600, 1632, 1646, 1649, 1749, 1765, 1774, 1791, 1808, 1810, 1869, 1920, 1969, 2308, 2365, 2384, 2392, 2406, 2429, 2437, 2447, 2451, 2474, 2482, 2486, 2493, 2510, 2524, 2527, 2534, 2548, 2565, 2575, 2579, 2602, 2610, 2613, 2616, 2649, 2654, 2662, 2674, 2693, 2703, 2707, 2730, 2738, 2741, 2749, 2768, 2784, 2790, 2821, 2831, 2835, 2858, 2866, 2869, 2877, 2908, 2911, 2918, 2929, 2947, 2949, 2958, 2962, 2969, 2972, 2974, 2979, 2984, 2990, 3046, 3077, 3086, 3090, 3114, 3125, 3168, 3174, 3205, 3214, 3218, 3242, 3253, 3261, 3294, 3296, 3302, 3333, 3342, 3346, 3370, 3424, 3430, 3461, 3482, 3507, 3517, 3520, 3585, 3634, 3648, 3664, 3713, 3716, 3719, 3722, 3725, 3732, 3737, 3745, 3749, 3751, 3754, 3757, 3762, 3773, 3776, 3782, 3792, 3804, 3840, 3872, 3904, 3913, 3976, 4096, 4131, 4137, 4160, 4176, 4256, 4304, 4348, 4352, 4447, 4520, 4608, 4682, 4688, 4696, 4698, 4704, 4746, 4752, 4786, 4792, 4800, 4802, 4808, 4824, 4882, 4888, 4969, 4992, 5024, 5121, 5743, 5761, 5792, 5870, 5888, 5902, 5920, 5952, 5984, 5998, 6016, 6103, 6108, 6112, 6128, 6160, 6176, 6272, 6400, 6470, 6512, 6528, 6593, 6608, 6656, 7424, 7680, 7840, 7936, 7960, 7968, 8008, 8016, 8025, 8027, 8029, 8031, 8064, 8118, 8126, 8130, 8134, 8144, 8150, 8160, 8178, 8182, 8304, 8308, 8319, 8336, 8450, 8455, 8458, 8469, 8473, 8484, 8486, 8488, 8490, 8495, 8499, 8508, 8517, 8531, 9312, 9450, 10102, 11264, 11312, 11392, 11517, 11520, 11568, 11631, 11648, 11680, 11688, 11696, 11704, 11712, 11720, 11728, 11736, 12293, 12321, 12337, 12344, 12353, 12445, 12449, 12540, 12549, 12593, 12690, 12704, 12784, 12832, 12881, 12928, 12977, 13312, 19968, 40960, 43008, 43011, 43015, 43020, 44032, 63744, 64048, 64112, 64256, 64275, 64285, 64287, 64298, 64312, 64318, 64320, 64323, 64326, 64467, 64848, 64914, 65008, 65136, 65142, 65296, 65313, 65345, 65382, 65474, 65482, 65490, 65498, 65536, 65549, 65576, 65596, 65599, 65616, 65664, 65799, 65856, 65930, 66304, 66336, 66352, 66432, 66464, 66504, 66513, 66560, 66720, 67584, 67592, 67594, 67639, 67644, 67647, 68096, 68112, 68117, 68121, 68160, 119808, 119894, 119966, 119970, 119973, 119977, 119982, 119995, 119997, 120005, 120071, 120077, 120086, 120094, 120123, 120128, 120134, 120138, 120146, 120488, 120514, 120540, 120572, 120598, 120630, 120656, 120688, 120714, 120746, 120772, 120782, 131072, 194560};
    private static int[] endPoints = new int[]{57, 90, 122, 170, 179, 181, 186, 190, 214, 246, 577, 705, 721, 740, 750, 890, 902, 906, 908, 929, 974, 1013, 1153, 1230, 1273, 1295, 1366, 1369, 1415, 1514, 1522, 1594, 1610, 1641, 1647, 1747, 1749, 1766, 1788, 1791, 1808, 1839, 1901, 1957, 1969, 2361, 2365, 2384, 2401, 2415, 2429, 2444, 2448, 2472, 2480, 2482, 2489, 2493, 2510, 2525, 2529, 2545, 2553, 2570, 2576, 2600, 2608, 2611, 2614, 2617, 2652, 2654, 2671, 2676, 2701, 2705, 2728, 2736, 2739, 2745, 2749, 2768, 2785, 2799, 2828, 2832, 2856, 2864, 2867, 2873, 2877, 2909, 2913, 2927, 2929, 2947, 2954, 2960, 2965, 2970, 2972, 2975, 2980, 2986, 3001, 3058, 3084, 3088, 3112, 3123, 3129, 3169, 3183, 3212, 3216, 3240, 3251, 3257, 3261, 3294, 3297, 3311, 3340, 3344, 3368, 3385, 3425, 3439, 3478, 3505, 3515, 3517, 3526, 3632, 3635, 3654, 3673, 3714, 3716, 3720, 3722, 3725, 3735, 3743, 3747, 3749, 3751, 3755, 3760, 3763, 3773, 3780, 3782, 3801, 3805, 3840, 3891, 3911, 3946, 3979, 4129, 4135, 4138, 4169, 4181, 4293, 4346, 4348, 4441, 4514, 4601, 4680, 4685, 4694, 4696, 4701, 4744, 4749, 4784, 4789, 4798, 4800, 4805, 4822, 4880, 4885, 4954, 4988, 5007, 5108, 5740, 5750, 5786, 5866, 5872, 5900, 5905, 5937, 5969, 5996, 6000, 6067, 6103, 6108, 6121, 6137, 6169, 6263, 6312, 6428, 6509, 6516, 6569, 6599, 6617, 6678, 7615, 7835, 7929, 7957, 7965, 8005, 8013, 8023, 8025, 8027, 8029, 8061, 8116, 8124, 8126, 8132, 8140, 8147, 8155, 8172, 8180, 8188, 8305, 8313, 8329, 8340, 8450, 8455, 8467, 8469, 8477, 8484, 8486, 8488, 8493, 8497, 8505, 8511, 8521, 8579, 9371, 9471, 10131, 11310, 11358, 11492, 11517, 11557, 11621, 11631, 11670, 11686, 11694, 11702, 11710, 11718, 11726, 11734, 11742, 12295, 12329, 12341, 12348, 12438, 12447, 12538, 12543, 12588, 12686, 12693, 12727, 12799, 12841, 12895, 12937, 12991, 19893, 40891, 42124, 43009, 43013, 43018, 43042, 55203, 64045, 64106, 64217, 64262, 64279, 64285, 64296, 64310, 64316, 64318, 64321, 64324, 64433, 64829, 64911, 64967, 65019, 65140, 65276, 65305, 65338, 65370, 65470, 65479, 65487, 65495, 65500, 65547, 65574, 65594, 65597, 65613, 65629, 65786, 65843, 65912, 65930, 66334, 66339, 66378, 66461, 66499, 66511, 66517, 66717, 66729, 67589, 67592, 67637, 67640, 67644, 67647, 68096, 68115, 68119, 68147, 68167, 119892, 119964, 119967, 119970, 119974, 119980, 119993, 119995, 120003, 120069, 120074, 120084, 120092, 120121, 120126, 120132, 120134, 120144, 120485, 120512, 120538, 120570, 120596, 120628, 120654, 120686, 120712, 120744, 120770, 120777, 120831, 173782, 195101};
    private static IntRangeSet alphanumerics = new IntRangeSet(startPoints, endPoints);

    public static boolean isAlphanumeric(int codepoint) {
        return alphanumerics.contains(codepoint);
    }

    public static int getDigitValue(int in) {
        for (int z = 0; z < zeroDigits.length; ++z) {
            if (in > zeroDigits[z] + 9) continue;
            if (in >= zeroDigits[z]) {
                return in - zeroDigits[z];
            }
            return -1;
        }
        return -1;
    }

    public static int getDigitFamily(int in) {
        for (int z = 0; z < zeroDigits.length; ++z) {
            if (in > zeroDigits[z] + 9) continue;
            if (in >= zeroDigits[z]) {
                return zeroDigits[z];
            }
            return -1;
        }
        return -1;
    }

    private Alphanumeric() {
    }
}

