/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.sf.ehcache.constructs.web.Header;
import net.sf.ehcache.constructs.web.HttpDateFormatter;
import net.sf.ehcache.constructs.web.filter.FilterServletOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericResponseWrapper
extends HttpServletResponseWrapper
implements Serializable {
    private static final long serialVersionUID = -5976708169031065497L;
    private static final Logger LOG = LoggerFactory.getLogger(GenericResponseWrapper.class);
    private int statusCode = 200;
    private int contentLength;
    private String contentType;
    private final Map<String, List<Serializable>> headersMap = new TreeMap<String, List<Serializable>>(String.CASE_INSENSITIVE_ORDER);
    private final List cookies = new ArrayList();
    private ServletOutputStream outstr;
    private PrintWriter writer;
    private boolean disableFlushBuffer = true;
    private transient HttpDateFormatter httpDateFormatter;

    public GenericResponseWrapper(HttpServletResponse response, OutputStream outstr) {
        super(response);
        this.outstr = new FilterServletOutputStream(outstr);
    }

    public ServletOutputStream getOutputStream() {
        return this.outstr;
    }

    public void setStatus(int code) {
        this.statusCode = code;
        super.setStatus(code);
    }

    public void sendError(int i, String string) throws IOException {
        this.statusCode = i;
        super.sendError(i, string);
    }

    public void sendError(int i) throws IOException {
        this.statusCode = i;
        super.sendError(i);
    }

    public void sendRedirect(String string) throws IOException {
        this.statusCode = 302;
        super.sendRedirect(string);
    }

    public void setStatus(int code, String msg) {
        this.statusCode = code;
        LOG.warn("Discarding message because this method is deprecated.");
        super.setStatus(code);
    }

    public int getStatus() {
        return this.statusCode;
    }

    public void setContentLength(int length) {
        this.contentLength = length;
        super.setContentLength(length);
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentType(String type) {
        this.contentType = type;
        super.setContentType(type);
    }

    public String getContentType() {
        return this.contentType;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.outstr, this.getCharacterEncoding()), true);
        }
        return this.writer;
    }

    public void addHeader(String name, String value) {
        List<Serializable> values = this.headersMap.get(name);
        if (values == null) {
            values = new LinkedList<Serializable>();
            this.headersMap.put(name, values);
        }
        values.add((Serializable)((Object)value));
        super.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        LinkedList<String> values = new LinkedList<String>();
        values.add(value);
        this.headersMap.put(name, values);
        super.setHeader(name, value);
    }

    public void addDateHeader(String name, long date) {
        List<Serializable> values = this.headersMap.get(name);
        if (values == null) {
            values = new LinkedList<Serializable>();
            this.headersMap.put(name, values);
        }
        values.add(Long.valueOf(date));
        super.addDateHeader(name, date);
    }

    public void setDateHeader(String name, long date) {
        LinkedList<Long> values = new LinkedList<Long>();
        values.add(date);
        this.headersMap.put(name, values);
        super.setDateHeader(name, date);
    }

    public void addIntHeader(String name, int value) {
        List<Serializable> values = this.headersMap.get(name);
        if (values == null) {
            values = new LinkedList<Serializable>();
            this.headersMap.put(name, values);
        }
        values.add(Integer.valueOf(value));
        super.addIntHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        LinkedList<Integer> values = new LinkedList<Integer>();
        values.add(value);
        this.headersMap.put(name, values);
        super.setIntHeader(name, value);
    }

    private HttpDateFormatter getHttpDateFormatter() {
        if (this.httpDateFormatter == null) {
            this.httpDateFormatter = new HttpDateFormatter();
        }
        return this.httpDateFormatter;
    }

    @Deprecated
    public Collection getHeaders() {
        ArrayList<String[]> headers = new ArrayList<String[]>(this.headersMap.size());
        for (Map.Entry<String, List<Serializable>> headerEntry : this.headersMap.entrySet()) {
            String name = headerEntry.getKey();
            block6: for (Serializable value : headerEntry.getValue()) {
                Header.Type type = Header.Type.determineType(value.getClass());
                switch (type) {
                    case STRING: {
                        headers.add(new String[]{name, (String)((Object)value)});
                        continue block6;
                    }
                    case DATE: {
                        HttpDateFormatter localHttpDateFormatter = this.getHttpDateFormatter();
                        String formattedValue = localHttpDateFormatter.formatHttpDate(new Date((Long)value));
                        headers.add(new String[]{name, formattedValue});
                        continue block6;
                    }
                    case INT: {
                        headers.add(new String[]{name, ((Integer)value).toString()});
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("No mapping for Header.Type: " + (Object)((Object)type));
            }
        }
        return Collections.unmodifiableCollection(headers);
    }

    public Collection<Header<? extends Serializable>> getAllHeaders() {
        LinkedList<Header<? extends Serializable>> headers = new LinkedList<Header<? extends Serializable>>();
        for (Map.Entry<String, List<Serializable>> headerEntry : this.headersMap.entrySet()) {
            String name = headerEntry.getKey();
            block6: for (Serializable value : headerEntry.getValue()) {
                Header.Type type = Header.Type.determineType(value.getClass());
                switch (type) {
                    case STRING: {
                        headers.add(new Header<String>(name, (String)((Object)value)));
                        continue block6;
                    }
                    case DATE: {
                        headers.add(new Header<Long>(name, (Long)value));
                        continue block6;
                    }
                    case INT: {
                        headers.add(new Header<Integer>(name, (Integer)value));
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("No mapping for Header.Type: " + (Object)((Object)type));
            }
        }
        return headers;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
        super.addCookie(cookie);
    }

    public Collection getCookies() {
        return this.cookies;
    }

    public void flushBuffer() throws IOException {
        this.flush();
        if (!this.disableFlushBuffer) {
            super.flushBuffer();
        }
    }

    public void reset() {
        super.reset();
        this.cookies.clear();
        this.headersMap.clear();
        this.statusCode = 200;
        this.contentType = null;
        this.contentLength = 0;
    }

    public void resetBuffer() {
        super.resetBuffer();
    }

    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        this.outstr.flush();
    }

    public boolean isDisableFlushBuffer() {
        return this.disableFlushBuffer;
    }

    public void setDisableFlushBuffer(boolean disableFlushBuffer) {
        this.disableFlushBuffer = disableFlushBuffer;
    }
}

