/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.people.action.people;

import cn.hutool.core.lang.Validator;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.people.action.BaseAction;
import net.mingsoft.people.biz.IPeopleAddressBiz;
import net.mingsoft.people.constant.Const;
import net.mingsoft.people.constant.ModelCode;
import net.mingsoft.people.entity.PeopleAddressEntity;
import net.mingsoft.people.entity.PeopleEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u666e\u901a\u7528\u6237\u6536\u8d27\u5730\u5740\u4fe1\u606f\u63a5\u53e3")
@Controller(value="peopleAddress")
@RequestMapping(value={"/people/address"})
public class PeopleAddressAction
extends BaseAction {
    @Autowired
    private IPeopleAddressBiz peopleAddressBiz;

    @ApiOperation(value="\u7528\u6237\u6536\u8d27\u5730\u5740\u5217\u8868\u63a5\u53e3")
    @GetMapping(value={"/list"})
    public void list(@ModelAttribute @ApiIgnore PeopleAddressEntity peopleAddress, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity people = this.getPeopleBySession();
        peopleAddress.setPeopleAddressAppId(BasicUtil.getAppId());
        peopleAddress.setPeopleAddressPeopleId(people.getPeopleId());
        List list = this.peopleAddressBiz.query(peopleAddress);
        this.outJson(response, JSONArray.toJSONString((Object)list));
    }

    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u6536\u8d27\u5730\u5740\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="peopleAddressConsigneeName", value="\u7528\u6237\u6536\u8d27\u4eba\u59d3\u540d", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressProvince", value="\u6536\u8d27\u4eba\u6240\u5728\u7684\u7701", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressProvinceId", value="\u6536\u8d27\u4eba\u6240\u5728\u7684\u7701\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressCity", value="\u6536\u8d27\u4eba\u6240\u5728\u7684\u5e02", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressCityId", value="\u6536\u8d27\u4eba\u6240\u5728\u7684\u5e02\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressDistrict", value="\u6536\u8d27\u4eba\u6240\u5728\u533a", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressDistrictId", value="\u6536\u8d27\u4eba\u6240\u5728\u533a\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressStreet", value="\u8857\u9053", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressStreetId", value="\u8857\u9053\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressAddress", value="\u6536\u8d27\u4eba\u7684\u8be6\u7ec6\u6536\u8d27\u5730\u5740", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressMail", value="\u6536\u8d27\u4eba\u90ae\u7bb1", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressPhone", value="\u6536\u8d27\u4eba\u624b\u673a", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressDefault", value="\u662f\u5426\u662f\u6536\u8d27\u4eba\u6700\u7ec8\u6536\u8d27\u5730\u5740\u30020\u4ee3\u8868\u662f\uff0c1\u4ee3\u8868\u4e0d\u662f\uff0c\u9ed8\u8ba4\u4e3a0", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    public void save(@ModelAttribute @ApiIgnore PeopleAddressEntity peopleAddress, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity peopleEntity = this.getPeopleBySession();
        if (peopleAddress == null) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("people.msg.null.error"), this.getResString("people.msg.null.error"));
            return;
        }
        if (StringUtils.isBlank((CharSequence)peopleAddress.getPeopleAddressPhone())) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("people.msg.phone.error", Const.RESOURCES));
            return;
        }
        if (!StringUtils.isBlank((CharSequence)peopleAddress.getPeopleAddressMail()) && !Validator.isEmail((String)peopleAddress.getPeopleAddressMail())) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("people.msg.mail.error", Const.RESOURCES));
            return;
        }
        if (StringUtils.isBlank((CharSequence)peopleAddress.getPeopleAddressProvince())) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("people.user.msg.null.error"));
            return;
        }
        peopleAddress.setPeopleAddressPeopleId(peopleEntity.getPeopleId());
        peopleAddress.setPeopleAddressAppId(BasicUtil.getAppId());
        this.peopleAddressBiz.saveEntity(peopleAddress);
        this.outJson(response, null, true, JSONObject.toJSONString((Object)((Object)peopleAddress)));
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u6536\u8d27\u5730\u5740\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="peopleAddressId", value="\u7528\u6237\u6536\u8d27\u5730\u5740\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressConsigneeName", value="\u7528\u6237\u6536\u8d27\u4eba\u59d3\u540d", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressProvince", value="\u6536\u8d27\u4eba\u6240\u5728\u7684\u7701", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressProvinceId", value="\u6536\u8d27\u4eba\u6240\u5728\u7684\u7701\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressCity", value="\u6536\u8d27\u4eba\u6240\u5728\u7684\u5e02", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressCityId", value="\u6536\u8d27\u4eba\u6240\u5728\u7684\u5e02\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressDistrict", value="\u6536\u8d27\u4eba\u6240\u5728\u533a", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressDistrictId", value="\u6536\u8d27\u4eba\u6240\u5728\u533a\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressStreet", value="\u8857\u9053", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressStreetId", value="\u8857\u9053\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressAddress", value="\u6536\u8d27\u4eba\u7684\u8be6\u7ec6\u6536\u8d27\u5730\u5740", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressMail", value="\u6536\u8d27\u4eba\u90ae\u7bb1", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressPhone", value="\u6536\u8d27\u4eba\u624b\u673a", required=true, paramType="query"), @ApiImplicitParam(name="peopleAddressDefault", value="\u662f\u5426\u662f\u6536\u8d27\u4eba\u6700\u7ec8\u6536\u8d27\u5730\u5740\u30020\u4ee3\u8868\u662f\uff0c1\u4ee3\u8868\u4e0d\u662f\uff0c\u9ed8\u8ba4\u4e3a0", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    public void update(@ModelAttribute @ApiIgnore PeopleAddressEntity peopleAddress, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity people = this.getPeopleBySession();
        peopleAddress.setPeopleAddressPeopleId(people.getPeopleId());
        PeopleAddressEntity address = (PeopleAddressEntity)((Object)this.peopleAddressBiz.getEntity(peopleAddress));
        if (people.getPeopleId() != address.getPeopleAddressPeopleId()) {
            this.outJson(response, false);
            return;
        }
        if (StringUtils.isBlank((CharSequence)peopleAddress.getPeopleAddressProvince()) || StringUtils.isBlank((CharSequence)peopleAddress.getPeopleAddressAddress())) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("people.address", Const.RESOURCES));
            return;
        }
        if (StringUtils.isBlank((CharSequence)peopleAddress.getPeopleAddressPhone())) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("people.msg.phone.error", Const.RESOURCES));
            return;
        }
        peopleAddress.setPeopleAddressPeopleId(people.getPeopleId());
        peopleAddress.setPeopleAddressAppId(BasicUtil.getAppId());
        this.peopleAddressBiz.updateEntity(peopleAddress);
        this.outJson(response, null, true);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u9ed8\u8ba4\u5730\u5740\u63a5\u53e3")
    @ApiImplicitParam(name="peopleAddressId", value="\u7528\u6237\u6536\u8d27\u5730\u5740\u7f16\u53f7", required=true, paramType="query")
    @PostMapping(value={"/setDefault"})
    public void setDefault(@ModelAttribute @ApiIgnore PeopleAddressEntity peopleAddress, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity people = this.getPeopleBySession();
        peopleAddress.setPeopleAddressPeopleId(people.getPeopleId());
        peopleAddress.setPeopleAddressAppId(BasicUtil.getAppId());
        this.peopleAddressBiz.setDefault(peopleAddress);
        this.outJson(response, null, true);
    }

    @ApiOperation(value="\u6839\u636e\u6536\u8d27\u5730\u5740\u7f16\u53f7\u5220\u9664\u6536\u8d27\u5730\u5740\u4fe1\u606f")
    @ApiImplicitParam(name="peopleAddressId", value="\u7528\u6237\u6536\u8d27\u5730\u5740\u7f16\u53f7", required=true, paramType="query")
    @PostMapping(value={"/delete"})
    public void delete(@ModelAttribute @ApiIgnore PeopleAddressEntity peopleAddress, HttpServletRequest request, HttpServletResponse response) {
        peopleAddress.setPeopleAddressPeopleId(this.getPeopleBySession().getPeopleId());
        peopleAddress.setPeopleAddressAppId(BasicUtil.getAppId());
        this.peopleAddressBiz.deleteEntity(peopleAddress);
        this.outJson(response, null, true);
    }

    @ApiOperation(value="\u83b7\u53d6\u6536\u8d27\u5730\u5740\u8be6\u60c5\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="peopleAddressId", value="\u7528\u6237\u6536\u8d27\u5730\u5740\u7f16\u53f7", required=true, paramType="query")})
    @GetMapping(value={"/get"})
    public void get(@ModelAttribute @ApiIgnore PeopleAddressEntity peopleAddress, HttpServletRequest request, HttpServletResponse response) {
        int peopleId = this.getPeopleBySession().getPeopleId();
        peopleAddress.setPeopleAddressPeopleId(peopleId);
        PeopleAddressEntity address = (PeopleAddressEntity)((Object)this.peopleAddressBiz.getEntity(peopleAddress));
        if (peopleId != address.getPeopleAddressPeopleId()) {
            this.outJson(response, false);
            return;
        }
        this.outJson(response, JSONObject.toJSONString((Object)((Object)address)));
    }
}

