/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.biz.IRoleModelBiz;
import net.mingsoft.basic.constant.ModelCode;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.entity.ModelEntity;
import net.mingsoft.basic.entity.RoleModelEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u83dc\u5355\u7ba1\u7406\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/model"})
public class ModelAction
extends BaseAction {
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IManagerBiz managerBiz;
    @Autowired
    private IRoleModelBiz roleModelBiz;

    @ApiOperation(value="\u8fd4\u56de\u4e3b\u754c\u9762index")
    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request, ModelMap mode) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        int currentRoleId = managerSession.getManagerRoleID();
        List<BaseEntity> parentModelList = this.modelBiz.queryModelByRoleId(currentRoleId);
        mode.addAttribute("parentModelList", (Object)com.alibaba.fastjson.JSONArray.toJSONString(parentModelList));
        return "/basic/model/index";
    }

    @ApiOperation(value="\u83dc\u5355\u5217\u8868\u63a5\u53e3")
    @GetMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        int currentRoleId = managerSession.getManagerRoleID();
        List<BaseEntity> modelList = this.modelBiz.queryModelByRoleId(currentRoleId);
        EUListBean _list = new EUListBean(modelList, modelList.size());
        this.outJson(response, JSONArray.toJSONString((Object)_list, (SerializeFilter[])new SerializeFilter[0]));
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u5757\u8868")
    @ApiImplicitParam(name="modelId", value="\u6a21\u5757\u7684\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (modelEntity.getModelId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("model.id")}));
            return;
        }
        ModelEntity _model = (ModelEntity)this.modelBiz.getEntity(modelEntity.getModelId());
        if (_model != null) {
            HashMap<String, ModelEntity> mode = new HashMap<String, ModelEntity>();
            ModelEntity parentModel = (ModelEntity)this.modelBiz.getEntity(_model.getModelModelId());
            mode.put("parentModel", parentModel);
            mode.put("model", _model);
            this.outJson(response, JSONObject.toJSONString(mode));
            return;
        }
        this.outJson(response, _model);
    }

    @ApiOperation(value="\u4fdd\u5b58\u6a21\u5757\u8868\u5b9e\u4f53")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelTitle", value="\u6a21\u5757\u7684\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="modelCode", value="\u6a21\u5757\u7f16\u7801", required=false, paramType="query"), @ApiImplicitParam(name="modelModelId", value="\u6a21\u5757\u7236id", required=false, paramType="query"), @ApiImplicitParam(name="modelUrl", value="\u94fe\u63a5\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="modelDatetime", value="\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="modelIcon", value="\u6a21\u5757\u56fe\u6807", required=false, paramType="query"), @ApiImplicitParam(name="modelManagerId", value="\u6a21\u5757\u7ba1\u7406\u5458Id", required=false, paramType="query"), @ApiImplicitParam(name="modelSort", value="\u6a21\u5757\u6392\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="modelIsMenu", value="\u662f\u5426\u662f\u83dc\u5355", required=false, paramType="query"), @ApiImplicitParam(name="isChild", value="\u83dc\u5355\u7c7b\u578b", required=false, paramType="query"), @ApiImplicitParam(name="modelParentIds", value="\u7236\u7ea7\u7f16\u53f7\u96c6\u5408", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"model:save"})
    public void save(@ModelAttribute @ApiIgnore ModelEntity model, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank(model.getModelTitle())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("model.title")}));
            return;
        }
        if (!StringUtil.checkLength(model.getModelTitle() + "", 1, 10)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("model.title"), "1", "10"}));
            return;
        }
        model.setModelId(this.getManagerId(request));
        model.setModelDatetime(new Timestamp(System.currentTimeMillis()));
        if (!StringUtil.isBlank(model.getModelIcon())) {
            model.setModelIcon(model.getModelIcon().replace("|", ""));
        }
        ModelEntity parent = (ModelEntity)this.modelBiz.getEntity(model.getModelModelId());
        String parentIds = "";
        if (parent != null) {
            parentIds = parent.getModelParentIds() != null ? parent.getModelParentIds() + "," + model.getModelModelId() : model.getModelModelId() + "";
        }
        if (parentIds.split(",").length > 1 && model.getModelIsMenu() == 1) {
            this.outJson(response, null, false, this.getResString("model.is.not.menu"));
            return;
        }
        model.setModelParentIds(parentIds);
        this.modelBiz.saveEntity(model);
        if (model.getModelId() > 0) {
            ManagerSessionEntity managerSession = this.getManagerBySession(request);
            ArrayList<RoleModelEntity> roleModels = new ArrayList<RoleModelEntity>();
            RoleModelEntity rolemodel = new RoleModelEntity();
            rolemodel.setModelId(model.getModelId());
            rolemodel.setRoleId(managerSession.getManagerRoleID());
            roleModels.add(rolemodel);
            this.roleModelBiz.saveEntity(roleModels);
        }
        model.setModelCode(model.getModelId() + "");
        this.modelBiz.updateEntity(model);
        this.outJson(response, ModelCode.ROLE, true, String.valueOf(model.getModelId()));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6a21\u5757\u8868")
    @ApiImplicitParam(name="ids", value="\u6a21\u5757\u7f16\u53f7\uff0c\u591a\u4e2a\u4ee5\u9017\u53f7\u9694\u5f00", required=false, paramType="query")
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"model:del"})
    public void delete(HttpServletResponse response, HttpServletRequest request) {
        int[] ids = BasicUtil.getInts("ids", ",");
        this.modelBiz.delete(ids);
        this.outJson(response, true);
    }

    @ApiOperation(value="\u66f4\u65b0\u6a21\u5757\u8868\u4fe1\u606f\u6a21\u5757\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u6a21\u5757\u7684\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="modelTitle", value="\u6a21\u5757\u7684\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="modelCode", value="\u6a21\u5757\u7f16\u7801", required=false, paramType="query"), @ApiImplicitParam(name="modelModelId", value="\u6a21\u5757\u7236id", required=false, paramType="query"), @ApiImplicitParam(name="modelUrl", value="\u94fe\u63a5\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="modelDatetime", value="\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="modelIcon", value="\u6a21\u5757\u56fe\u6807", required=false, paramType="query"), @ApiImplicitParam(name="modelManagerId", value="\u6a21\u5757\u7ba1\u7406\u5458Id", required=false, paramType="query"), @ApiImplicitParam(name="modelSort", value="\u6a21\u5757\u6392\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="modelIsMenu", value="\u662f\u5426\u662f\u83dc\u5355", required=false, paramType="query"), @ApiImplicitParam(name="isChild", value="\u83dc\u5355\u7c7b\u578b", required=false, paramType="query"), @ApiImplicitParam(name="modelParentIds", value="\u7236\u7ea7\u7f16\u53f7\u96c6\u5408", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"model:update"})
    @ResponseBody
    public void update(@ModelAttribute @ApiIgnore ModelEntity model, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank(model.getModelTitle())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("model.title")}));
            return;
        }
        if (!StringUtil.checkLength(model.getModelTitle() + "", 1, 10)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("model.title"), "1", "10"}));
            return;
        }
        ModelEntity _model = (ModelEntity)this.modelBiz.getEntity(model.getModelId());
        if (_model.getModelIsMenu() == 1 && model.getModelIsMenu() == 0) {
            this.outJson(response, null, false, this.getResString("model.is.menu"));
            return;
        }
        if (!StringUtil.isBlank(model.getModelIcon())) {
            model.setModelIcon(model.getModelIcon().replace("|", ""));
        }
        ModelEntity parent = (ModelEntity)this.modelBiz.getEntity(model.getModelModelId());
        String parentIds = "";
        if (parent != null) {
            parentIds = parent.getModelParentIds() != null ? parent.getModelParentIds() + "," + model.getModelModelId() : model.getModelModelId() + "";
        }
        if (parentIds.split(",").length > 1 && model.getModelIsMenu() == 1) {
            this.outJson(response, null, false, this.getResString("model.is.not.menu"));
            return;
        }
        model.setModelParentIds(parentIds);
        this.modelBiz.updateEntity(model);
        this.outJson(response, ModelCode.ROLE, true, String.valueOf(model.getModelId()));
    }

    @ApiOperation(value="\u6839\u636e\u7ba1\u7406\u5458ID\u67e5\u8be2\u6a21\u5757\u96c6\u5408")
    @ApiImplicitParam(name="managerId", value="\u7ba1\u7406\u5458id", required=true, paramType="path")
    @GetMapping(value={"/{managerId}/queryModelByRoleId"})
    public void queryModelByRoleId(@PathVariable @ApiIgnore int managerId, HttpServletRequest request, HttpServletResponse response) {
        ManagerEntity manager = (ManagerEntity)this.managerBiz.getEntity(managerId);
        if (manager == null) {
            return;
        }
        List<Object> modelList = new ArrayList();
        modelList = this.modelBiz.queryModelByRoleId(manager.getManagerRoleID());
        this.outJson(response, null, true, JSONObject.toJSONString(modelList));
    }

    @ApiOperation(value="\u67e5\u8be2\u6a21\u5757\u8868\u5217\u8868")
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/modelList"})
    @ResponseBody
    public void modelList(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        int roleId = BasicUtil.getInt("roleId");
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        int currentRoleId = managerSession.getManagerRoleID();
        boolean updateFalg = true;
        if (roleId == 0) {
            updateFalg = false;
            roleId = currentRoleId;
        }
        List<BaseEntity> modelList = this.modelBiz.queryModelByRoleId(currentRoleId);
        ArrayList<ModelEntity> _modelList = new ArrayList<ModelEntity>();
        List<Object> roleModelList = new ArrayList();
        if (roleId > 0) {
            roleModelList = this.roleModelBiz.queryByRoleId(roleId);
        }
        ArrayList<ModelEntity> childModelList = new ArrayList<ModelEntity>();
        for (BaseEntity base : modelList) {
            ModelEntity _model = (ModelEntity)base;
            if (_model.getModelIsMenu() == 1) {
                _model.setModelChildList(new ArrayList<ModelEntity>());
                _modelList.add(_model);
                continue;
            }
            if (_model.getModelIsMenu() != 0) continue;
            childModelList.add(_model);
        }
        for (ModelEntity _modelEntity : _modelList) {
            for (ModelEntity childModel : childModelList) {
                if (childModel.getModelModelId() != _modelEntity.getModelId()) continue;
                _modelEntity.getModelChildList().add(childModel);
                for (RoleModelEntity roleModelEntity : roleModelList) {
                    if (roleModelEntity.getModelId() != childModel.getModelId() || !updateFalg) continue;
                    childModel.setChick(1);
                }
            }
        }
        EUListBean _list = new EUListBean(_modelList, _modelList.size());
        this.outJson(response, JSONArray.toJSONString((Object)_list, (SerializeFilter[])new SerializeFilter[0]));
    }
}

