/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.util;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.contextfw.web.application.configuration.Configuration;
import net.contextfw.web.application.internal.ToStringSerializer;
import net.contextfw.web.application.internal.configuration.KeyValue;
import net.contextfw.web.application.internal.util.ObjectAttributeSerializer;
import net.contextfw.web.application.serialize.AttributeSerializer;

@Singleton
public class AttributeHandler
implements ObjectAttributeSerializer {
    private final Map<Class<?>, AttributeSerializer<Object>> serializers = new HashMap();
    private ToStringSerializer toStringSerializer = new ToStringSerializer();

    @Inject
    public AttributeHandler(Injector injector, Configuration conf) {
        for (KeyValue entry : (Set)conf.get(Configuration.ATTRIBUTE_SERIALIZER)) {
            this.serializers.put((Class<?>)entry.getKey(), (AttributeSerializer)injector.getInstance((Class)entry.getValue()));
        }
        for (KeyValue entry : (Set)conf.get(Configuration.ATTRIBUTE_JSON_SERIALIZER)) {
            this.serializers.put((Class<?>)entry.getKey(), (AttributeSerializer)injector.getInstance((Class)entry.getValue()));
        }
    }

    @Override
    public String serialize(Object source) {
        if (source != null) {
            Class<?> cl = source.getClass();
            if (this.serializers.containsKey(cl)) {
                return this.serializers.get(cl).serialize(source);
            }
            return this.toStringSerializer.serialize(source);
        }
        return null;
    }
}

