/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.servlet;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.regex.Pattern;
import net.contextfw.web.application.component.Component;
import net.contextfw.web.application.internal.servlet.InitServlet;
import net.contextfw.web.application.internal.servlet.UriMapping;

public class PathStyleUriMapping
extends UriMapping {
    private final String pattern;
    private final Kind patternKind;

    public PathStyleUriMapping(@NonNull Class<? extends Component> viewClass, @NonNull String pattern, @NonNull InitServlet initServlet, @NonNull Map<String, Pattern> variables) {
        super(viewClass, pattern, initServlet, UriMapping.Type.SERVLET, variables);
        if (pattern.startsWith("*")) {
            this.pattern = pattern.substring(1);
            this.patternKind = Kind.PREFIX;
        } else if (pattern.endsWith("*")) {
            this.pattern = pattern.substring(0, pattern.length() - 1);
            this.patternKind = Kind.SUFFIX;
        } else {
            this.pattern = pattern;
            this.patternKind = Kind.LITERAL;
        }
    }

    @Override
    public boolean matches(String uri) {
        if (null == uri) {
            return false;
        }
        if (this.patternKind == Kind.PREFIX) {
            return uri.endsWith(this.pattern);
        }
        if (this.patternKind == Kind.SUFFIX) {
            return uri.startsWith(this.pattern);
        }
        return this.pattern.equals(uri);
    }

    @Override
    public String extractPath(String pattern) {
        if (this.patternKind == Kind.PREFIX) {
            return null;
        }
        if (this.patternKind == Kind.SUFFIX) {
            String extract = pattern;
            if (extract.endsWith("/")) {
                extract = extract.substring(0, extract.length() - 1);
            }
            return extract;
        }
        return this.getPath();
    }

    private static enum Kind {
        PREFIX,
        SUFFIX,
        LITERAL;

    }
}

