/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.component.DOMBuilder;
import net.contextfw.web.application.internal.component.Builder;

class MethodCustomBuilder
extends Builder {
    private final Method method;
    private final String name;

    public MethodCustomBuilder(Method method, String name) {
        super(method.getName());
        if (method.getParameterTypes().length == 0 || method.getParameterTypes().length > 1 || method.getParameterTypes()[0] != DOMBuilder.class) {
            throw new WebApplicationException("Method " + method.getDeclaringClass().getName() + "." + method.getName() + "() must take only one parameter of type DOMBuilder");
        }
        this.method = method;
        this.name = name;
    }

    @Override
    public void build(DOMBuilder b, Object buildable) {
        try {
            this.method.invoke(buildable, this.name == null ? b : b.descend(this.name));
        }
        catch (RuntimeException e) {
            throw new WebApplicationException(e);
        }
        catch (IllegalAccessException e) {
            throw new WebApplicationException(e);
        }
        catch (InvocationTargetException e) {
            throw new WebApplicationException(e);
        }
    }
}

