/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.constant;

import java.lang.reflect.Field;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;

public class FieldConstant
implements StackManipulation {
    private final FieldDescription.InDefinedShape fieldDescription;

    public FieldConstant(FieldDescription.InDefinedShape fieldDescription) {
        this.fieldDescription = fieldDescription;
    }

    public StackManipulation cached() {
        return new Cached(this);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        try {
            return new StackManipulation.Compound(ClassConstant.of(this.fieldDescription.getDeclaringType()), new TextConstant(this.fieldDescription.getInternalName()), MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(Class.class.getMethod("getDeclaredField", String.class)))).apply(methodVisitor, implementationContext);
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalStateException("Cannot locate Class::getDeclaredField", exception);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldConstant)) {
            return false;
        }
        FieldConstant other = (FieldConstant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FieldDescription.InDefinedShape this$fieldDescription = this.fieldDescription;
        FieldDescription.InDefinedShape other$fieldDescription = other.fieldDescription;
        return !(this$fieldDescription == null ? other$fieldDescription != null : !this$fieldDescription.equals(other$fieldDescription));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FieldConstant;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FieldDescription.InDefinedShape $fieldDescription = this.fieldDescription;
        result = result * 59 + ($fieldDescription == null ? 43 : $fieldDescription.hashCode());
        return result;
    }

    protected static class Cached
    implements StackManipulation {
        private final StackManipulation fieldConstant;

        public Cached(StackManipulation fieldConstant) {
            this.fieldConstant = fieldConstant;
        }

        @Override
        public boolean isValid() {
            return this.fieldConstant.isValid();
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return FieldAccess.forField(implementationContext.cache(this.fieldConstant, new TypeDescription.ForLoadedType(Field.class))).read().apply(methodVisitor, implementationContext);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cached)) {
                return false;
            }
            Cached other = (Cached)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StackManipulation this$fieldConstant = this.fieldConstant;
            StackManipulation other$fieldConstant = other.fieldConstant;
            return !(this$fieldConstant == null ? other$fieldConstant != null : !this$fieldConstant.equals(other$fieldConstant));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cached;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StackManipulation $fieldConstant = this.fieldConstant;
            result = result * 59 + ($fieldConstant == null ? 43 : $fieldConstant.hashCode());
            return result;
        }
    }
}

