/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.conf;

import com.mysql.cj.api.conf.ModifiableProperty;
import com.mysql.cj.api.conf.PropertyDefinition;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.core.conf.ReadableIntegerProperty;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import java.io.Serializable;

public class ModifiableIntegerProperty
extends ReadableIntegerProperty
implements ModifiableProperty<Integer>,
Serializable {
    private static final long serialVersionUID = 1954410331604145901L;

    protected ModifiableIntegerProperty(PropertyDefinition<Integer> propertyDefinition) {
        super(propertyDefinition);
    }

    @Override
    protected void initializeFrom(String extractedValue, ExceptionInterceptor exceptionInterceptor) {
        super.initializeFrom(extractedValue, exceptionInterceptor);
        this.initialValue = this.value;
    }

    @Override
    public void setFromString(String value, ExceptionInterceptor exceptionInterceptor) {
        this.setValue((Integer)this.getPropertyDefinition().parseObject(value, exceptionInterceptor), value, exceptionInterceptor);
    }

    @Override
    public void setValue(Integer value) {
        this.setValue(value, null, null);
    }

    @Override
    public void setValue(Integer value, ExceptionInterceptor exceptionInterceptor) {
        this.setValue(value, null, exceptionInterceptor);
    }

    private void setValue(int intValue, String valueAsString, ExceptionInterceptor exceptionInterceptor) {
        if (this.getPropertyDefinition().isRangeBased() && (intValue < this.getPropertyDefinition().getLowerBound() || intValue > this.getPropertyDefinition().getUpperBound())) {
            throw ExceptionFactory.createException(WrongArgumentException.class, "The connection property '" + this.getPropertyDefinition().getName() + "' only accepts integer values in the range of " + this.getPropertyDefinition().getLowerBound() + " - " + this.getPropertyDefinition().getUpperBound() + ", the value '" + (valueAsString == null ? Integer.valueOf(intValue) : valueAsString) + "' exceeds this range.", exceptionInterceptor);
        }
        this.value = intValue;
        this.wasExplicitlySet = true;
        this.invokeListeners();
    }

    @Override
    public void resetValue() {
        this.value = this.initialValue;
        this.invokeListeners();
    }
}

