/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.io;

import com.mysql.cj.api.conf.ReadableProperty;
import com.mysql.cj.api.io.SocketConnection;
import com.mysql.cj.api.mysqla.io.PacketHeader;
import com.mysql.cj.api.mysqla.io.PacketPayload;
import com.mysql.cj.api.mysqla.io.PacketReader;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.CJPacketTooBigException;
import com.mysql.cj.mysqla.io.Buffer;
import com.mysql.cj.mysqla.io.DefaultPacketHeader;
import java.io.IOException;
import java.util.Optional;

public class SimplePacketReader
implements PacketReader {
    protected SocketConnection socketConnection;
    protected ReadableProperty<Integer> maxAllowedPacket;
    private byte readPacketSequence = (byte)-1;

    public SimplePacketReader(SocketConnection socketConnection, ReadableProperty<Integer> maxAllowedPacket) {
        this.socketConnection = socketConnection;
        this.maxAllowedPacket = maxAllowedPacket;
    }

    @Override
    public PacketHeader readHeader() throws IOException {
        DefaultPacketHeader hdr = new DefaultPacketHeader();
        try {
            this.socketConnection.getMysqlInput().readFully(hdr.getBuffer(), 0, 4);
            int packetLength = hdr.getPacketLength();
            if (packetLength > this.maxAllowedPacket.getValue()) {
                throw new CJPacketTooBigException(packetLength, this.maxAllowedPacket.getValue().intValue());
            }
        }
        catch (CJPacketTooBigException | IOException e) {
            try {
                this.socketConnection.forceClose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        this.readPacketSequence = hdr.getPacketSequence();
        return hdr;
    }

    @Override
    public PacketPayload readPayload(Optional<PacketPayload> reuse, int packetLength) throws IOException {
        try {
            PacketPayload buf;
            if (reuse.isPresent()) {
                buf = reuse.get();
                buf.setPosition(0);
                if (buf.getByteBuffer().length < packetLength) {
                    buf.setByteBuffer(new byte[packetLength]);
                }
                buf.setPayloadLength(packetLength);
            } else {
                buf = new Buffer(new byte[packetLength]);
            }
            int numBytesRead = this.socketConnection.getMysqlInput().readFully(buf.getByteBuffer(), 0, packetLength);
            if (numBytesRead != packetLength) {
                throw new IOException(Messages.getString("PacketReader.1", new Object[]{packetLength, numBytesRead}));
            }
            return buf;
        }
        catch (IOException e) {
            try {
                this.socketConnection.forceClose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public byte getPacketSequence() {
        return this.readPacketSequence;
    }

    @Override
    public void resetPacketSequence() {
        this.readPacketSequence = 0;
    }
}

