/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.api.ProfilerEventHandler;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.api.exceptions.StreamingNotifiable;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.jdbc.ResultSetInternalMethods;
import com.mysql.cj.api.jdbc.RowData;
import com.mysql.cj.core.Constants;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.profiler.ProfilerEventHandlerFactory;
import com.mysql.cj.core.profiler.ProfilerEventImpl;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.core.util.Util;
import com.mysql.cj.jdbc.ResultSetImpl;
import com.mysql.cj.jdbc.ResultSetRow;
import com.mysql.cj.jdbc.StatementImpl;
import com.mysql.cj.jdbc.exceptions.OperationNotSupportedException;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.mysqla.io.MysqlaProtocol;
import java.sql.SQLException;
import java.sql.Statement;

public class RowDataDynamic
implements RowData {
    private int columnCount;
    private Field[] metadata;
    private int index = -1;
    private MysqlaProtocol io;
    private boolean isAfterEnd = false;
    private boolean noMoreRows = false;
    private boolean isBinaryEncoded = false;
    private ResultSetRow nextRow;
    private ResultSetImpl owner;
    private boolean streamerClosed = false;
    private boolean wasEmpty = false;
    private boolean moreResultsExisted;
    private ExceptionInterceptor exceptionInterceptor;

    public RowDataDynamic(MysqlaProtocol io, int colCount, Field[] fields, boolean isBinaryEncoded) throws SQLException {
        this.io = io;
        this.columnCount = colCount;
        this.isBinaryEncoded = isBinaryEncoded;
        this.metadata = fields;
        this.exceptionInterceptor = this.io.getExceptionInterceptor();
    }

    @Override
    public void addRow(ResultSetRow row) throws SQLException {
        this.notSupported();
    }

    @Override
    public void afterLast() throws SQLException {
        this.notSupported();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.notSupported();
    }

    @Override
    public void beforeLast() throws SQLException {
        this.notSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Object mutex = this;
        JdbcConnection conn = null;
        if (this.owner != null && (conn = this.owner.connection) != null) {
            mutex = conn.getConnectionMutex();
        }
        boolean hadMore = false;
        int howMuchMore = 0;
        RowDataDynamic rowDataDynamic = mutex;
        synchronized (rowDataDynamic) {
            while (this.next() != null) {
                hadMore = true;
                if (++howMuchMore % 100 != 0) continue;
                Thread.yield();
            }
            if (conn != null) {
                if (!conn.getPropertySet().getBooleanReadableProperty("clobberStreamingResults").getValue().booleanValue() && conn.getPropertySet().getIntegerReadableProperty("netTimeoutForStreamingResults").getValue() > 0) {
                    int oldValue = conn.getSession().getServerVariable("net_write_timeout", 60);
                    this.io.clearInputStream();
                    try (Statement stmt = null;){
                        stmt = conn.createStatement();
                        ((StatementImpl)stmt).executeSimpleNonQuery(conn, "SET net_write_timeout=" + oldValue);
                    }
                }
                if (conn.getPropertySet().getBooleanReadableProperty("useUsageAdvisor").getValue().booleanValue() && hadMore) {
                    try {
                        ProfilerEventHandler eventSink = ProfilerEventHandlerFactory.getInstance(conn);
                        eventSink.consumeEvent(new ProfilerEventImpl(0, "", this.owner.owningStatement == null ? "N/A" : this.owner.owningStatement.currentCatalog, this.owner.connectionId, this.owner.owningStatement == null ? -1 : this.owner.owningStatement.getId(), -1, System.currentTimeMillis(), 0L, Constants.MILLIS_I18N, null, null, Messages.getString("RowDataDynamic.2") + howMuchMore + Messages.getString("RowDataDynamic.3") + Messages.getString("RowDataDynamic.4") + Messages.getString("RowDataDynamic.5") + Messages.getString("RowDataDynamic.6") + this.owner.pointOfOrigin));
                    }
                    catch (CJException e) {
                        throw SQLExceptionsMapping.translateException(e, conn.getExceptionInterceptor());
                    }
                }
            }
        }
        this.metadata = null;
        this.owner = null;
    }

    @Override
    public ResultSetRow getAt(int ind) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public int getCurrentRowNumber() throws SQLException {
        this.notSupported();
        return -1;
    }

    @Override
    public ResultSetInternalMethods getOwner() {
        return this.owner;
    }

    @Override
    public boolean hasNext() throws SQLException {
        boolean hasNext;
        boolean bl = hasNext = this.nextRow != null;
        if (!hasNext && !this.streamerClosed) {
            this.io.getResultsHandler().closeStreamer(this);
            this.streamerClosed = true;
        }
        return hasNext;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.isAfterEnd;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.index < 0;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public boolean isEmpty() throws SQLException {
        this.notSupported();
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.notSupported();
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.notSupported();
        return false;
    }

    @Override
    public void moveRowRelative(int rows) throws SQLException {
        this.notSupported();
    }

    @Override
    public ResultSetRow next() throws SQLException {
        this.nextRecord();
        if (this.nextRow == null && !this.streamerClosed && !this.moreResultsExisted) {
            this.io.getResultsHandler().closeStreamer(this);
            this.streamerClosed = true;
        }
        if (this.nextRow != null && this.index != Integer.MAX_VALUE) {
            ++this.index;
        }
        return this.nextRow;
    }

    private void nextRecord() throws SQLException {
        try {
            if (!this.noMoreRows) {
                this.nextRow = this.io.getResultsHandler().nextRow(this.metadata, this.columnCount, this.isBinaryEncoded, 1007, true);
                if (this.nextRow == null) {
                    this.noMoreRows = true;
                    this.isAfterEnd = true;
                    this.moreResultsExisted = this.io.getResultsHandler().tackOnMoreStreamingResults(this.owner, this.isBinaryEncoded);
                    if (this.index == -1) {
                        this.wasEmpty = true;
                    }
                }
            } else {
                this.nextRow = null;
                this.isAfterEnd = true;
            }
        }
        catch (CJException | SQLException sqlEx) {
            SQLException cause;
            SQLException sQLException = cause = sqlEx instanceof SQLException ? (SQLException)sqlEx : SQLExceptionsMapping.translateException(sqlEx);
            if (cause instanceof StreamingNotifiable) {
                ((StreamingNotifiable)((Object)cause)).setWasStreamingResults();
            }
            this.noMoreRows = true;
            throw cause;
        }
        catch (Exception ex) {
            String exceptionType = ex.getClass().getName();
            String exceptionMessage = ex.getMessage();
            exceptionMessage = exceptionMessage + Messages.getString("RowDataDynamic.7");
            exceptionMessage = exceptionMessage + Util.stackTraceToString(ex);
            SQLException sqlEx = SQLError.createSQLException(Messages.getString("RowDataDynamic.8") + exceptionType + Messages.getString("RowDataDynamic.9") + exceptionMessage, "S1000", this.exceptionInterceptor);
            sqlEx.initCause(ex);
            throw sqlEx;
        }
    }

    private void notSupported() throws SQLException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void removeRow(int ind) throws SQLException {
        this.notSupported();
    }

    @Override
    public void setCurrentRow(int rowNumber) throws SQLException {
        this.notSupported();
    }

    @Override
    public void setOwner(ResultSetImpl rs) {
        this.owner = rs;
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public boolean wasEmpty() {
        return this.wasEmpty;
    }

    @Override
    public void setMetadata(Field[] metadata) {
        this.metadata = metadata;
    }
}

