/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import me.zhyd.oauth.authorization.AuthorizationFactory;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthSource;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.request.ResponseStatus;
import me.zhyd.oauth.utils.AuthConfigChecker;

public abstract class BaseAuthRequest
implements AuthRequest {
    protected AuthConfig config;
    protected AuthSource source;

    public BaseAuthRequest(AuthConfig config, AuthSource source) {
        this.config = config;
        this.source = source;
        if (!AuthConfigChecker.isSupportedAuth(config)) {
            throw new AuthException(ResponseStatus.PARAMETER_INCOMPLETE);
        }
    }

    protected abstract AuthToken getAccessToken(String var1);

    protected abstract AuthUser getUserInfo(AuthToken var1);

    @Override
    public AuthResponse login(String code) {
        try {
            AuthToken authToken = this.getAccessToken(code);
            AuthUser user = this.getUserInfo(authToken);
            return AuthResponse.builder().code(ResponseStatus.SUCCESS.getCode()).data(user).build();
        }
        catch (Exception e) {
            return this.responseError(e);
        }
    }

    private AuthResponse responseError(Exception e) {
        int errorCode = ResponseStatus.FAILURE.getCode();
        if (e instanceof AuthException) {
            errorCode = ((AuthException)e).getErrorCode();
        }
        return AuthResponse.builder().code(errorCode).msg(e.getMessage()).build();
    }

    @Override
    public String authorize() {
        return AuthorizationFactory.getAuthorize(this.source).getAuthorizeUrl(this.config);
    }

    public AuthConfig getConfig() {
        return this.config;
    }

    public AuthSource getSource() {
        return this.source;
    }

    public void setConfig(AuthConfig config) {
        this.config = config;
    }

    public void setSource(AuthSource source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseAuthRequest)) {
            return false;
        }
        BaseAuthRequest other = (BaseAuthRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AuthConfig this$config = this.getConfig();
        AuthConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        AuthSource this$source = this.getSource();
        AuthSource other$source = other.getSource();
        return !(this$source == null ? other$source != null : !((Object)((Object)this$source)).equals((Object)other$source));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseAuthRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AuthConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        AuthSource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)((Object)$source)).hashCode());
        return result;
    }

    public String toString() {
        return "BaseAuthRequest(config=" + this.getConfig() + ", source=" + (Object)((Object)this.getSource()) + ")";
    }
}

