/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthSource;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.BaseAuthRequest;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthGiteeRequest
extends BaseAuthRequest {
    public AuthGiteeRequest(AuthConfig config) {
        super(config, AuthSource.GITEE);
    }

    @Override
    protected AuthToken getAccessToken(String code) {
        String accessTokenUrl = UrlBuilder.getGiteeAccessTokenUrl(this.config.getClientId(), this.config.getClientSecret(), code, this.config.getRedirectUri());
        HttpResponse response = HttpRequest.post((String)accessTokenUrl).execute();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response.body());
        if (accessTokenObject.containsKey((Object)"error")) {
            throw new AuthException("Unable to get token from gitee using code [" + code + "]");
        }
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        HttpResponse response = HttpRequest.get((String)UrlBuilder.getGiteeUserInfoUrl(accessToken)).execute();
        String userInfo = response.body();
        JSONObject object = JSONObject.parseObject((String)userInfo);
        return AuthUser.builder().uuid(object.getString("id")).username(object.getString("login")).avatar(object.getString("avatar_url")).blog(object.getString("blog")).nickname(object.getString("name")).company(object.getString("company")).location(object.getString("address")).email(object.getString("email")).remark(object.getString("bio")).token(authToken).source(AuthSource.GITEE).build();
    }
}

