/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthSource;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.model.AuthUserGender;
import me.zhyd.oauth.request.BaseAuthRequest;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthFacebookRequest
extends BaseAuthRequest {
    public AuthFacebookRequest(AuthConfig config) {
        super(config, AuthSource.FACEBOOK);
    }

    @Override
    protected AuthToken getAccessToken(String code) {
        String accessTokenUrl = UrlBuilder.getFacebookAccessTokenUrl(this.config.getClientId(), this.config.getClientSecret(), code, this.config.getRedirectUri());
        HttpResponse response = HttpRequest.post((String)accessTokenUrl).execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getJSONObject("error").getString("message"));
        }
        return AuthToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).tokenType(object.getString("token_type")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        HttpResponse response = HttpRequest.get((String)UrlBuilder.getFacebookUserInfoUrl(accessToken)).execute();
        String userInfo = response.body();
        JSONObject object = JSONObject.parseObject((String)userInfo);
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getJSONObject("error").getString("message"));
        }
        String picture = null;
        if (object.containsKey((Object)"picture")) {
            JSONObject pictureObj = object.getJSONObject("picture");
            if (null != (pictureObj = pictureObj.getJSONObject("data"))) {
                picture = pictureObj.getString("url");
            }
        }
        return AuthUser.builder().uuid(object.getString("id")).username(object.getString("name")).nickname(object.getString("name")).avatar(picture).location(object.getString("locale")).email(object.getString("email")).gender(AuthUserGender.getRealGender(object.getString("gender"))).token(authToken).source(AuthSource.FACEBOOK).build();
    }
}

