/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import java.util.Objects;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthDingTalkErrorCode;
import me.zhyd.oauth.model.AuthSource;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.BaseAuthRequest;
import me.zhyd.oauth.utils.GlobalAuthUtil;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthDingTalkRequest
extends BaseAuthRequest {
    public AuthDingTalkRequest(AuthConfig config) {
        super(config, AuthSource.DINGTALK);
    }

    @Override
    protected AuthToken getAccessToken(String code) {
        return AuthToken.builder().accessCode(code).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String code = authToken.getAccessCode();
        String stringToSign = System.currentTimeMillis() + "";
        String urlEncodeSignature = GlobalAuthUtil.generateDingTalkSignature(this.config.getClientSecret(), stringToSign);
        HttpResponse response = HttpRequest.post((String)UrlBuilder.getDingTalkUserInfoUrl(urlEncodeSignature, stringToSign, this.config.getClientId())).body((JSON)Objects.requireNonNull(new JSONObject().put("tmp_auth_code", (Object)code))).execute();
        String userInfo = response.body();
        JSONObject object = new JSONObject((CharSequence)userInfo);
        AuthDingTalkErrorCode errorCode = AuthDingTalkErrorCode.getErrorCode(object.getInt((Object)"errcode"));
        if (!AuthDingTalkErrorCode.EC0.equals((Object)errorCode)) {
            throw new AuthException(errorCode.getDesc());
        }
        object = object.getJSONObject((Object)"user_info");
        return AuthUser.builder().uuid(object.getStr((Object)"openid")).nickname(object.getStr((Object)"nick")).username(object.getStr((Object)"nick")).source(AuthSource.DINGTALK).build();
    }
}

