/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthSource;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.BaseAuthRequest;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthCsdnRequest
extends BaseAuthRequest {
    public AuthCsdnRequest(AuthConfig config) {
        super(config, AuthSource.CSDN);
    }

    @Override
    protected AuthToken getAccessToken(String code) {
        String accessTokenUrl = UrlBuilder.getCsdnAccessTokenUrl(this.config.getClientId(), this.config.getClientSecret(), code, this.config.getRedirectUri());
        HttpResponse response = HttpRequest.post((String)accessTokenUrl).execute();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response.body());
        if (accessTokenObject.containsKey((Object)"error_code")) {
            throw new AuthException("Unable to get token from csdn using code [" + code + "]");
        }
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        HttpResponse response = HttpRequest.get((String)UrlBuilder.getCsdnUserInfoUrl(accessToken)).execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        if (object.containsKey((Object)"error_code")) {
            throw new AuthException(object.getString("error"));
        }
        return AuthUser.builder().uuid(object.getString("username")).username(object.getString("username")).remark(object.getString("description")).blog(object.getString("website")).token(authToken).source(AuthSource.CSDN).build();
    }
}

