/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthSource;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.model.AuthUserGender;
import me.zhyd.oauth.request.BaseAuthRequest;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthCodingRequest
extends BaseAuthRequest {
    public AuthCodingRequest(AuthConfig config) {
        super(config, AuthSource.CODING);
    }

    @Override
    protected AuthToken getAccessToken(String code) {
        String accessTokenUrl = UrlBuilder.getCodingAccessTokenUrl(this.config.getClientId(), this.config.getClientSecret(), code);
        HttpResponse response = HttpRequest.get((String)accessTokenUrl).execute();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response.body());
        if (accessTokenObject.getIntValue("code") != 0) {
            throw new AuthException("Unable to get token from coding using code [" + code + "]");
        }
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        HttpResponse response = HttpRequest.get((String)UrlBuilder.getCodingUserInfoUrl(accessToken)).execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        if (object.getIntValue("code") != 0) {
            throw new AuthException(object.getString("msg"));
        }
        object = object.getJSONObject("data");
        return AuthUser.builder().uuid(object.getString("id")).username(object.getString("name")).avatar("https://coding.net/" + object.getString("avatar")).blog("https://coding.net/" + object.getString("path")).nickname(object.getString("name")).company(object.getString("company")).location(object.getString("location")).gender(AuthUserGender.getRealGender(object.getString("sex"))).email(object.getString("email")).remark(object.getString("slogan")).token(authToken).source(AuthSource.CODING).build();
    }
}

