/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.model;

import me.zhyd.oauth.utils.StringUtils;

public enum AuthBaiduErrorCode {
    OK("ok", "ok", "ok"),
    INVALID_REQUEST("invalid_request", "invalid refresh token", "\u8bf7\u6c42\u7f3a\u5c11\u67d0\u4e2a\u5fc5\u9700\u53c2\u6570\uff0c\u5305\u542b\u4e00\u4e2a\u4e0d\u652f\u6301\u7684\u53c2\u6570\u6216\u53c2\u6570\u503c\uff0c\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e\u3002"),
    INVALID_CLIENT("invalid_client", "unknown client id", "client_id\u201d\u3001\u201cclient_secret\u201d\u53c2\u6570\u65e0\u6548\u3002"),
    INVALID_GRANT("invalid_grant", "The provided authorization grant is revoked", "\u63d0\u4f9b\u7684Access Grant\u662f\u65e0\u6548\u7684\u3001\u8fc7\u671f\u7684\u6216\u5df2\u64a4\u9500\u7684\uff0c\u4f8b\u5982\uff0cAuthorization Code\u65e0\u6548(\u4e00\u4e2a\u6388\u6743\u7801\u53ea\u80fd\u4f7f\u7528\u4e00\u6b21)\u3001Refresh Token\u65e0\u6548\u3001redirect_uri\u4e0e\u83b7\u53d6Authorization Code\u65f6\u63d0\u4f9b\u7684\u4e0d\u4e00\u81f4\u3001Devie Code\u65e0\u6548(\u4e00\u4e2a\u8bbe\u5907\u6388\u6743\u7801\u53ea\u80fd\u4f7f\u7528\u4e00\u6b21)\u7b49\u3002"),
    UNAUTHORIZED_CLIENT("unauthorized_client", "The client is not authorized to use this authorization grant type", "\u5e94\u7528\u6ca1\u6709\u88ab\u6388\u6743\uff0c\u65e0\u6cd5\u4f7f\u7528\u6240\u6307\u5b9a\u7684grant_type\u3002"),
    UNSUPPORTED_GRANT_TYPE("unsupported_grant_type", "The authorization grant type is not supported", "\u201cgrant_type\u201d\u767e\u5ea6OAuth2.0\u670d\u52a1\u4e0d\u652f\u6301\u8be5\u53c2\u6570\u3002"),
    INVALID_SCOPE("invalid_scope", "The requested scope is exceeds the scope granted by the resource owner", "\u8bf7\u6c42\u7684\u201cscope\u201d\u53c2\u6570\u662f\u65e0\u6548\u7684\u3001\u672a\u77e5\u7684\u3001\u683c\u5f0f\u4e0d\u6b63\u786e\u7684\u3001\u6216\u6240\u8bf7\u6c42\u7684\u6743\u9650\u8303\u56f4\u8d85\u8fc7\u4e86\u6570\u636e\u62e5\u6709\u8005\u6240\u6388\u4e88\u7684\u6743\u9650\u8303\u56f4\u3002"),
    EXPIRED_TOKEN("expired_token", "refresh token has been used", "\u63d0\u4f9b\u7684Refresh Token\u5df2\u8fc7\u671f"),
    REDIRECT_URI_MISMATCH("redirect_uri_mismatch", "Invalid redirect uri", "\u201credirect_uri\u201d\u6240\u5728\u7684\u6839\u57df\u4e0e\u5f00\u53d1\u8005\u6ce8\u518c\u5e94\u7528\u65f6\u6240\u586b\u5199\u7684\u6839\u57df\u540d\u4e0d\u5339\u914d\u3002"),
    UNSUPPORTED_RESPONSE_TYPE("unsupported_response_type", "The response type is not supported", "\u201cresponse_type\u201d\u53c2\u6570\u503c\u4e0d\u4e3a\u767e\u5ea6OAuth2.0\u670d\u52a1\u6240\u652f\u6301\uff0c\u6216\u8005\u5e94\u7528\u5df2\u7ecf\u4e3b\u52a8\u7981\u7528\u4e86\u5bf9\u5e94\u7684\u6388\u6743\u6a21\u5f0f"),
    SLOW_DOWN("slow_down", "The device is polling too frequently", "Device Flow\u4e2d\uff0c\u8bbe\u5907\u901a\u8fc7Device Code\u6362\u53d6Access Token\u7684\u63a5\u53e3\u8fc7\u4e8e\u9891\u7e41\uff0c\u4e24\u6b21\u5c1d\u8bd5\u7684\u95f4\u9694\u5e94\u5927\u4e8e5\u79d2\u3002"),
    AUTHORIZATION_PENDING("authorization_pending", "User has not yet completed the authorization", "Device Flow\u4e2d\uff0c\u7528\u6237\u8fd8\u6ca1\u6709\u5bf9Device Code\u5b8c\u6210\u6388\u6743\u64cd\u4f5c\u3002"),
    AUTHORIZATION_DECLINED("authorization_declined", "User has declined the authorization", "Device Flow\u4e2d\uff0c\u7528\u6237\u62d2\u7edd\u4e86\u5bf9Device Code\u7684\u6388\u6743\u64cd\u4f5c\u3002"),
    INVALID_REFERER("invalid_referer", "Invalid Referer", "Implicit Grant\u6a21\u5f0f\u4e2d\uff0c\u6d4f\u89c8\u5668\u8bf7\u6c42\u7684Referer\u4e0e\u6839\u57df\u540d\u7ed1\u5b9a\u4e0d\u5339\u914d");

    private String code;
    private String msg;
    private String desc;

    private AuthBaiduErrorCode(String code, String msg, String desc) {
        this.code = code;
        this.msg = msg;
        this.desc = desc;
    }

    public static AuthBaiduErrorCode getErrorCode(String code) {
        AuthBaiduErrorCode[] errorCodes;
        if (StringUtils.isEmpty(code)) {
            return OK;
        }
        for (AuthBaiduErrorCode errorCode : errorCodes = AuthBaiduErrorCode.values()) {
            if (!code.equalsIgnoreCase(errorCode.getCode())) continue;
            return errorCode;
        }
        return OK;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getDesc() {
        return this.desc;
    }
}

