/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.finance.Bills;
import eleme.openapi.sdk.api.entity.finance.BranchQuery;
import eleme.openapi.sdk.api.entity.finance.FinanceOrders;
import eleme.openapi.sdk.api.entity.finance.HeadQuery;
import eleme.openapi.sdk.api.entity.finance.OBalanceLogResponse;
import eleme.openapi.sdk.api.entity.finance.OQueryBalanceLogRequest;
import eleme.openapi.sdk.api.entity.finance.OQueryBalanceResponse;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.HashMap;

@Service(value="eleme.finance")
public class FinanceService
extends BaseNopService {
    public FinanceService(Config config, Token token) {
        super(config, token, FinanceService.class);
    }

    public OQueryBalanceResponse queryBalance(int shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (OQueryBalanceResponse)this.call("eleme.finance.queryBalance", params);
    }

    public OBalanceLogResponse queryBalanceLog(OQueryBalanceLogRequest request) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return (OBalanceLogResponse)this.call("eleme.finance.queryBalanceLog", params);
    }

    public Bills queryHeadBills(Long shopId, HeadQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (Bills)this.call("eleme.finance.queryHeadBills", params);
    }

    public FinanceOrders queryHeadOrders(Long shopId, HeadQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (FinanceOrders)this.call("eleme.finance.queryHeadOrders", params);
    }

    public Bills queryBranchBills(Long shopId, BranchQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (Bills)this.call("eleme.finance.queryBranchBills", params);
    }

    public FinanceOrders queryBranchOrders(Long shopId, BranchQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (FinanceOrders)this.call("eleme.finance.queryBranchOrders", params);
    }

    public FinanceOrders getOrder(Long shopId, String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("orderId", orderId);
        return (FinanceOrders)this.call("eleme.finance.getOrder", params);
    }
}

