/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.mysql;

import com.github.kristofa.brave.ClientTracer;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSetInternalMethods;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.StatementInterceptorV2;
import com.twitter.zipkin.gen.Endpoint;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Properties;

public class MySQLStatementInterceptor
implements StatementInterceptorV2 {
    private static final String SERVICE_NAME_KEY = "zipkinServiceName";
    static volatile ClientTracer clientTracer;

    public static void setClientTracer(ClientTracer tracer) {
        clientTracer = tracer;
    }

    public ResultSetInternalMethods preProcess(String sql, Statement interceptedStatement, Connection connection) throws SQLException {
        ClientTracer clientTracer = MySQLStatementInterceptor.clientTracer;
        if (clientTracer != null) {
            String sqlToLog = interceptedStatement instanceof PreparedStatement ? ((PreparedStatement)interceptedStatement).getPreparedSql() : sql;
            this.beginTrace(clientTracer, sqlToLog, connection);
        }
        return null;
    }

    public ResultSetInternalMethods postProcess(String sql, Statement interceptedStatement, ResultSetInternalMethods originalResultSet, Connection connection, int warningCount, boolean noIndexUsed, boolean noGoodIndexUsed, SQLException statementException) throws SQLException {
        ClientTracer clientTracer = MySQLStatementInterceptor.clientTracer;
        if (clientTracer != null) {
            this.endTrace(clientTracer, warningCount, statementException);
        }
        return null;
    }

    private void beginTrace(ClientTracer tracer, String sql, Connection connection) throws SQLException {
        tracer.startNewSpan("query");
        tracer.submitBinaryAnnotation("sql.query", sql);
        try {
            this.setClientSent(tracer, connection);
        }
        catch (Exception e) {
            tracer.setClientSent();
        }
    }

    private void setClientSent(ClientTracer tracer, Connection connection) throws Exception {
        InetAddress address = Inet4Address.getByName(connection.getHost());
        int ipv4 = ByteBuffer.wrap(address.getAddress()).getInt();
        URI url = URI.create(connection.getMetaData().getURL().substring(5));
        int port = url.getPort() == -1 ? 3306 : url.getPort();
        Properties props = connection.getProperties();
        String serviceName = props.getProperty(SERVICE_NAME_KEY);
        if (serviceName == null || "".equals(serviceName)) {
            serviceName = "mysql";
            String databaseName = connection.getCatalog();
            if (databaseName != null && !"".equals(databaseName)) {
                serviceName = serviceName + "-" + databaseName;
            }
        }
        tracer.setClientSent(Endpoint.builder().ipv4(ipv4).port(port).serviceName(serviceName).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endTrace(ClientTracer tracer, int warningCount, SQLException statementException) {
        try {
            if (warningCount > 0) {
                tracer.submitBinaryAnnotation("warning.count", warningCount);
            }
            if (statementException != null) {
                tracer.submitBinaryAnnotation("error", statementException.getErrorCode());
            }
        }
        finally {
            tracer.setClientReceived();
        }
    }

    public boolean executeTopLevelOnly() {
        return true;
    }

    public void init(Connection connection, Properties properties) throws SQLException {
    }

    public void destroy() {
    }
}

