/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import com.riversoft.weixin.mp.user.bean.User;
import com.riversoft.weixin.mp.user.bean.UserPagination;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Users {
    private static Logger logger = LoggerFactory.getLogger(Users.class);
    private WxClient wxClient;

    public static Users defaultUsers() {
        return Users.with(AppSetting.defaultSettings());
    }

    public static Users with(AppSetting appSetting) {
        Users users = new Users();
        users.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return users;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public User get(String openId) {
        return this.get(openId, "zh_CN");
    }

    public User get(String openId, String lang) {
        String url = WxEndpoint.get("url.user.get");
        try {
            String user = this.wxClient.get(String.format(url, openId, lang));
            logger.debug("get user: {}", (Object)user);
            return (User)JsonMapper.nonEmptyMapper().fromJson(user, User.class);
        }
        catch (WxRuntimeException e) {
            if (e.getCode() == 40003) {
                logger.warn("open id: {} not found.", (Object)openId);
                return null;
            }
            throw e;
        }
    }

    public UserPagination list() {
        return this.list(null);
    }

    public List<User> batchGet(String ... openIds) {
        if (openIds.length > 100) {
            throw new WxRuntimeException(999, "\u6279\u91cf\u83b7\u53d6\u7528\u6237\u57fa\u672c\u4fe1\u606f\u3002\u6700\u591a\u652f\u6301\u4e00\u6b21\u62c9\u53d6100\u6761");
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (String openId : openIds) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("openid", openId);
            map.put("lang", "zh_CN");
            list.add(map);
        }
        return this.batchGet(list);
    }

    public List<User> batchGet(List<Map<String, String>> openIds) {
        if (openIds.size() > 100) {
            throw new WxRuntimeException(999, "\u6279\u91cf\u83b7\u53d6\u7528\u6237\u57fa\u672c\u4fe1\u606f\u3002\u6700\u591a\u652f\u6301\u4e00\u6b21\u62c9\u53d6100\u6761");
        }
        String url = WxEndpoint.get("url.user.batchget");
        String body = "{\"user_list\":%s}";
        String json = JsonMapper.defaultMapper().toJson(openIds);
        logger.debug("batch get users.");
        String response = this.wxClient.post(url, String.format(body, json));
        UsersWrapper usersWrapper = (UsersWrapper)JsonMapper.defaultMapper().fromJson(response, UsersWrapper.class);
        return usersWrapper.getList();
    }

    public UserPagination list(String nextOpenId) {
        String url = WxEndpoint.get("url.user.list");
        if (nextOpenId != null && !"".equals(nextOpenId)) {
            url = url + "?next_openid=" + nextOpenId;
        }
        String response = this.wxClient.get(url);
        logger.debug("list users: {}", (Object)response);
        return (UserPagination)JsonMapper.defaultMapper().fromJson(response, UserPagination.class);
    }

    public void remark(String openId, String remark) {
        String url = WxEndpoint.get("url.user.remark");
        String json = String.format("{\"openid\":\"%s\",\"remark\":\"%s\"}", openId, remark);
        logger.debug("remark user: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    static class UsersWrapper {
        @JsonProperty(value="user_info_list")
        private List<User> list;

        UsersWrapper() {
        }

        public List<User> getList() {
            return this.list;
        }

        public void setList(List<User> list) {
            this.list = list;
        }
    }
}

