/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.media;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.media.MediaType;
import com.riversoft.weixin.common.media.MpArticle;
import com.riversoft.weixin.common.media.MpNews;
import com.riversoft.weixin.common.media.Video;
import com.riversoft.weixin.common.util.DateDeserializer;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import com.riversoft.weixin.mp.media.bean.Counts;
import com.riversoft.weixin.mp.media.bean.Material;
import com.riversoft.weixin.mp.media.bean.MaterialPagination;
import com.riversoft.weixin.mp.media.bean.MpNewsPagination;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Materials {
    private static Logger logger = LoggerFactory.getLogger(Materials.class);
    private WxClient wxClient;

    public static Materials defaultMaterials() {
        return Materials.with(AppSetting.defaultSettings());
    }

    public static Materials with(AppSetting appSetting) {
        Materials materials = new Materials();
        materials.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return materials;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public String addMpNewsImage(InputStream inputStream, String fileName) {
        String url = WxEndpoint.get("url.mpnews.image.upload");
        String response = this.wxClient.post(url, inputStream, fileName);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("url")) {
            return result.get("url").toString();
        }
        logger.warn("mpnews image upload failed: {}", (Object)response);
        throw new WxRuntimeException(999, response);
    }

    public String addMpNews(MpNews mpNews) {
        String url = WxEndpoint.get("url.material.mpnews.add");
        String json = JsonMapper.nonEmptyMapper().toJson((Object)mpNews);
        logger.info("add mpnews: {}", (Object)json);
        String response = this.wxClient.post(url, json);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("media_id")) {
            return result.get("media_id").toString();
        }
        logger.warn("mpnews add failed: {}", (Object)response);
        throw new WxRuntimeException(999, response);
    }

    public MpNews getMpNews(String mediaId) {
        String url = WxEndpoint.get("url.material.mpnews.get");
        String json = String.format("{\"media_id\":\"%s\"}", mediaId);
        logger.info("get mpnews: {}", (Object)json);
        String response = this.wxClient.post(url, json);
        return (MpNews)JsonMapper.defaultMapper().fromJson(response, MpNews.class);
    }

    public void updateMpNews(String mediaId, int index, MpArticle article) {
        String url = WxEndpoint.get("url.material.mpnews.update");
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("media_id", mediaId);
        request.put("index", index);
        request.put("articles", article);
        String json = JsonMapper.nonEmptyMapper().toJson(request);
        logger.info("update mpnews: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public Material addVoice(InputStream inputStream, String fileName) {
        return this.upload(MediaType.voice, inputStream, fileName);
    }

    public InputStream getVoice(String mediaId) {
        return this.download(mediaId);
    }

    public Material addImage(InputStream inputStream, String fileName) {
        return this.upload(MediaType.image, inputStream, fileName);
    }

    public InputStream getImage(String mediaId) {
        return this.download(mediaId);
    }

    public Material addThumb(InputStream inputStream, String fileName) {
        return this.upload(MediaType.thumb, inputStream, fileName);
    }

    public InputStream getThumb(String mediaId) {
        return this.download(mediaId);
    }

    public Material addVideo(InputStream inputStream, String fileName, String title, String description) {
        String url = WxEndpoint.get("url.material.binary.upload");
        String desc = "{\"title\":\"%s\",\"introduction\":\"%s\"}";
        HashMap<String, String> form = new HashMap<String, String>();
        form.put("description", String.format(desc, title, description));
        String response = this.wxClient.post(String.format(url, MediaType.video.name()), inputStream, fileName, form);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("media_id")) {
            return (Material)JsonMapper.defaultMapper().fromJson(response, Material.class);
        }
        logger.warn("image upload failed: {}", (Object)response);
        throw new WxRuntimeException(999, response);
    }

    public Video getVideo(String mediaId) {
        String response = this.wxClient.get(String.format(WxEndpoint.get("url.material.binary.get"), mediaId));
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("title")) {
            return (Video)JsonMapper.defaultMapper().fromJson(response, Video.class);
        }
        logger.warn("download video failed: {}", (Object)response);
        throw new WxRuntimeException(999, response);
    }

    public Counts count() {
        String response = this.wxClient.get(WxEndpoint.get("url.material.count"));
        return (Counts)JsonMapper.defaultMapper().fromJson(response, Counts.class);
    }

    public MaterialPagination list(MediaType mediaType, int offset, int count) {
        if (mediaType != MediaType.news && mediaType != MediaType.mpnews) {
            String url = WxEndpoint.get("url.material.list");
            String body = "{\"type\":\"%s\",\"offset\":%s,\"count\":%s}";
            String response = this.wxClient.post(url, String.format(body, mediaType.name(), offset, count));
            logger.debug("list materials: {}", (Object)response);
            return this.toMaterialSearchResult((MpMaterialSearchResult)JsonMapper.defaultMapper().fromJson(response, MpMaterialSearchResult.class));
        }
        throw new WxRuntimeException(999, "cannot support mpnews list.");
    }

    public MpNewsPagination listMpNews(int offset, int count) {
        String url = WxEndpoint.get("url.material.list");
        String body = "{\"type\":\"%s\",\"offset\":%s,\"count\":%s}";
        String response = this.wxClient.post(url, String.format(body, MediaType.news.name(), offset, count));
        logger.debug("list mpnwes: {}", (Object)response);
        return (MpNewsPagination)JsonMapper.defaultMapper().fromJson(response, MpNewsPagination.class);
    }

    private Material upload(MediaType type, InputStream inputStream, String fileName) {
        if (type == MediaType.mpnews || type == MediaType.video) {
            throw new WxRuntimeException(999, "cannot support mpnews or video upload.");
        }
        String url = WxEndpoint.get("url.material.binary.upload");
        String response = this.wxClient.post(String.format(url, type.name()), inputStream, fileName);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("media_id")) {
            return (Material)JsonMapper.defaultMapper().fromJson(response, Material.class);
        }
        logger.warn("image upload failed: {}", (Object)response);
        throw new WxRuntimeException(999, response);
    }

    private InputStream download(String mediaId) {
        String post = "{\"media_id\":\"%s\"}";
        return this.wxClient.copyStream(WxEndpoint.get("url.material.binary.get"), String.format(post, mediaId));
    }

    public void delete(String mediaId) {
        String url = WxEndpoint.get("url.material.delete");
        String body = String.format("{\"media_id\":\"%s\"}", mediaId);
        logger.debug("material delete: {}", (Object)body);
        this.wxClient.post(url, body);
    }

    private MaterialPagination toMaterialSearchResult(MpMaterialSearchResult mpMaterialSearchResult) {
        MaterialPagination result = new MaterialPagination();
        result.setTotalCount(mpMaterialSearchResult.getTotalCount());
        result.setCurrentCount(mpMaterialSearchResult.getCurrentCount());
        List<MpMaterialSearchResult.Material> qyItems = mpMaterialSearchResult.getItems();
        ArrayList<MaterialPagination.Material> items = new ArrayList<MaterialPagination.Material>();
        for (MpMaterialSearchResult.Material mpItem : qyItems) {
            MaterialPagination.Material item = new MaterialPagination.Material();
            item.setFileName(mpItem.getName());
            item.setMediaId(mpItem.getMediaId());
            item.setUpdateTime(mpItem.updateTime);
            item.setUrl(mpItem.getUrl());
            items.add(item);
        }
        result.setItems(items);
        return result;
    }

    public static class MpMaterialSearchResult {
        @JsonProperty(value="total_count")
        private int totalCount;
        @JsonProperty(value="item_count")
        private int currentCount;
        @JsonProperty(value="item")
        private List<Material> items;

        public int getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
        }

        public int getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(int currentCount) {
            this.currentCount = currentCount;
        }

        public List<Material> getItems() {
            return this.items;
        }

        public void setItems(List<Material> items) {
            this.items = items;
        }

        public static class Material {
            @JsonProperty(value="media_id")
            private String mediaId;
            private String name;
            @JsonProperty(value="update_time")
            @JsonDeserialize(using=DateDeserializer.class)
            private Date updateTime;
            private String url;

            public String getMediaId() {
                return this.mediaId;
            }

            public void setMediaId(String mediaId) {
                this.mediaId = mediaId;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public Date getUpdateTime() {
                return this.updateTime;
            }

            public void setUpdateTime(Date updateTime) {
                this.updateTime = updateTime;
            }

            public String getUrl() {
                return this.url;
            }

            public void setUrl(String url) {
                this.url = url;
            }
        }
    }
}

