/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.card;

import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import com.riversoft.weixin.mp.card.bean.Card;
import com.riversoft.weixin.mp.card.bean.Cash;
import com.riversoft.weixin.mp.card.bean.Color;
import com.riversoft.weixin.mp.card.bean.Coupon;
import com.riversoft.weixin.mp.card.bean.Discount;
import com.riversoft.weixin.mp.card.bean.Gift;
import com.riversoft.weixin.mp.card.bean.Groupon;
import com.riversoft.weixin.mp.card.bean.Member;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cards {
    private static Logger logger = LoggerFactory.getLogger(Cards.class);
    private WxClient wxClient;

    public static Cards defaultCards() {
        return Cards.with(AppSetting.defaultSettings());
    }

    public static Cards with(AppSetting appSetting) {
        Cards cards = new Cards();
        cards.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return cards;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public String groupon(Groupon groupon) {
        Card card = new Card();
        card.setCardType("GROUPON");
        card.setGroupon(groupon);
        return this.createCard(card);
    }

    public String cash(Cash cash) {
        Card card = new Card();
        card.setCardType("CASH");
        card.setCash(cash);
        return this.createCard(card);
    }

    public String gift(Gift gift) {
        Card card = new Card();
        card.setCardType("GIFT");
        card.setGift(gift);
        return this.createCard(card);
    }

    public String discount(Discount discount) {
        Card card = new Card();
        card.setCardType("DISCOUNT");
        card.setDiscount(discount);
        return this.createCard(card);
    }

    public String coupon(Coupon coupon) {
        Card card = new Card();
        card.setCardType("GENERAL_COUPON");
        card.setCoupon(coupon);
        return this.createCard(card);
    }

    public String member(Member member) {
        Card card = new Card();
        card.setCardType("MEMBER_CARD");
        card.setMember(member);
        return this.createCard(card);
    }

    private String createCard(Card card) {
        String json = JsonMapper.nonDefaultMapper().toJson((Object)new CardWrapper(card));
        logger.debug("create card: {}", (Object)json);
        String url = WxEndpoint.get("url.card.create");
        String response = this.wxClient.post(url, json);
        HashMap result = JsonMapper.nonDefaultMapper().json2Map(response);
        if (result.containsKey("card_id")) {
            return result.get("card_id").toString();
        }
        throw new WxRuntimeException(999, "create card failed.");
    }

    public int count(List<String> statusList) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("offset", 0);
        request.put("count", 1);
        if (statusList != null && !statusList.isEmpty()) {
            request.put("status_list", statusList);
        }
        String url = WxEndpoint.get("url.card.list");
        String json = JsonMapper.defaultMapper().toJson(request);
        String response = this.wxClient.post(url, json);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("total_num")) {
            return (Integer)result.get("total_num");
        }
        throw new WxRuntimeException(999, "create card failed.");
    }

    public List<String> list(int offset, int count, List<String> statusList) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("offset", offset);
        request.put("count", count);
        if (statusList != null && !statusList.isEmpty()) {
            request.put("status_list", statusList);
        }
        String url = WxEndpoint.get("url.card.list");
        String json = JsonMapper.defaultMapper().toJson(request);
        String response = this.wxClient.post(url, json);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("card_id_list")) {
            return (List)result.get("card_id_list");
        }
        throw new WxRuntimeException(999, "create card failed.");
    }

    public Card get(String cardId) {
        String json = "{\"card_id\":\"%s\"}";
        logger.debug("get card: {}", (Object)cardId);
        String url = WxEndpoint.get("url.card.get");
        String response = this.wxClient.post(url, String.format(json, cardId));
        CardWrapper cardWrapper = (CardWrapper)JsonMapper.defaultMapper().fromJson(response, CardWrapper.class);
        return cardWrapper.getCard();
    }

    public void setWhiteList(List<String> openIds, List<String> userNames) {
        HashMap<String, List<String>> request = new HashMap<String, List<String>>();
        if (openIds != null && !openIds.isEmpty()) {
            request.put("openid", openIds);
        }
        if (userNames != null && !userNames.isEmpty()) {
            request.put("username", userNames);
        }
        String url = WxEndpoint.get("url.card.test.whitelist");
        String json = JsonMapper.defaultMapper().toJson(request);
        logger.debug("set test white list: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    String getContentByCardId(String cardId) {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("card_id", cardId);
        String url = WxEndpoint.get("url.card.mpnews.gethtml");
        String json = JsonMapper.defaultMapper().toJson(request);
        logger.debug("get mpnews content by card id: {}", (Object)json);
        String response = this.wxClient.post(url, json);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("content")) {
            return result.get("content").toString();
        }
        throw new WxRuntimeException(999, "get html content by card id failed.");
    }

    public List<Color> listColors() {
        String url = WxEndpoint.get("url.card.colors.get");
        logger.debug("list colors.");
        String response = this.wxClient.get(url);
        ColorWrapper colorWrapper = (ColorWrapper)JsonMapper.defaultMapper().fromJson(response, ColorWrapper.class);
        return colorWrapper.getColors();
    }

    public static class CardWrapper {
        private Card card;

        public CardWrapper() {
        }

        public CardWrapper(Card card) {
            this.card = card;
        }

        public Card getCard() {
            return this.card;
        }

        public void setCard(Card card) {
            this.card = card;
        }
    }

    public static class ColorWrapper {
        private List<Color> colors;

        public List<Color> getColors() {
            return this.colors;
        }

        public void setColors(List<Color> colors) {
            this.colors = colors;
        }
    }
}

