/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.netty.handler.codec.http.QueryStringEncoder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.impl.ClientPhase;
import io.vertx.ext.web.client.impl.HttpRequestImpl;
import io.vertx.ext.web.client.impl.HttpResponseImpl;
import io.vertx.ext.web.client.impl.MultipartFormUpload;
import io.vertx.ext.web.codec.spi.BodyStream;
import io.vertx.ext.web.multipart.MultipartForm;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpContext<T> {
    private final Context context;
    private final Handler<AsyncResult<HttpResponse<T>>> handler;
    private final HttpClientImpl client;
    private final List<Handler<HttpContext<?>>> interceptors;
    private HttpRequestImpl<T> request;
    private Object body;
    private String contentType;
    private Map<String, Object> attrs;
    private Iterator<Handler<HttpContext<?>>> it;
    private ClientPhase phase;
    private HttpClientRequest clientRequest;
    private HttpClientResponse clientResponse;
    private HttpResponse<T> response;
    private Throwable failure;
    private int redirects;

    HttpContext(Context context, HttpClientImpl client, List<Handler<HttpContext<?>>> interceptors, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.context = context;
        this.handler = handler;
        this.client = client;
        this.interceptors = interceptors;
    }

    public HttpClientRequest clientRequest() {
        return this.clientRequest;
    }

    public HttpClientResponse clientResponse() {
        return this.clientResponse;
    }

    public ClientPhase phase() {
        return this.phase;
    }

    public HttpRequest<T> request() {
        return this.request;
    }

    public HttpResponse<T> response() {
        return this.response;
    }

    public HttpContext<T> response(HttpResponse<T> response) {
        this.response = response;
        return this;
    }

    public int redirects() {
        return this.redirects;
    }

    public HttpContext<T> redirects(int redirects) {
        this.redirects = redirects;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public Object body() {
        return this.body;
    }

    public Throwable failure() {
        return this.failure;
    }

    public void prepareRequest(HttpRequest<T> request, String contentType, Object body) {
        this.request = (HttpRequestImpl)request;
        this.contentType = contentType;
        this.body = body;
        this.fire(ClientPhase.PREPARE_REQUEST);
    }

    public void sendRequest(HttpClientRequest clientRequest) {
        this.clientRequest = clientRequest;
        this.fire(ClientPhase.SEND_REQUEST);
    }

    public void receiveResponse(HttpClientResponse clientResponse) {
        int maxRedirects;
        int sc = clientResponse.statusCode();
        int n = maxRedirects = this.request.followRedirects ? this.client.getOptions().getMaxRedirects() : 0;
        if (this.redirects < maxRedirects && sc >= 300 && sc < 400) {
            ++this.redirects;
            Future next = (Future)this.client.redirectHandler().apply(clientResponse);
            if (next != null) {
                next.setHandler(ar -> {
                    if (ar.succeeded()) {
                        this.sendRequest((HttpClientRequest)ar.result());
                    } else {
                        this.fail(ar.cause());
                    }
                });
                return;
            }
        }
        this.clientResponse = clientResponse;
        this.fire(ClientPhase.RECEIVE_RESPONSE);
    }

    public void dispatchResponse(HttpResponse<T> response) {
        this.response = response;
        this.fire(ClientPhase.DISPATCH_RESPONSE);
    }

    public boolean fail(Throwable cause) {
        if (this.phase == ClientPhase.FAILURE) {
            return false;
        }
        this.failure = cause;
        this.fire(ClientPhase.FAILURE);
        return true;
    }

    public void next() {
        if (this.it.hasNext()) {
            Handler<HttpContext<?>> next = this.it.next();
            next.handle((Object)this);
        } else {
            this.it = null;
            this.execute();
        }
    }

    private void fire(ClientPhase phase) {
        this.phase = phase;
        this.it = this.interceptors.iterator();
        this.next();
    }

    private void execute() {
        switch (this.phase) {
            case PREPARE_REQUEST: {
                this.handlePrepareRequest();
                break;
            }
            case SEND_REQUEST: {
                this.handleSendRequest();
                break;
            }
            case RECEIVE_RESPONSE: {
                this.handleReceiveResponse();
                break;
            }
            case DISPATCH_RESPONSE: {
                this.handleDispatchResponse();
                break;
            }
            case FAILURE: {
                this.handleFailure();
            }
        }
    }

    private void handleFailure() {
        this.handler.handle((Object)Future.failedFuture((Throwable)this.failure));
    }

    private void handleDispatchResponse() {
        this.handler.handle((Object)Future.succeededFuture(this.response));
    }

    private void handlePrepareRequest() {
        HttpClientRequest req;
        String requestURI;
        if (this.request.queryParams() != null && this.request.queryParams().size() > 0) {
            QueryStringEncoder enc = new QueryStringEncoder(this.request.uri);
            this.request.queryParams().forEach(param -> enc.addParam((String)param.getKey(), (String)param.getValue()));
            requestURI = enc.toString();
        } else {
            requestURI = this.request.uri;
        }
        int port = this.request.port;
        String host = this.request.host;
        if (this.request.ssl != this.request.options.isSsl()) {
            req = this.client.request(this.request.method, new RequestOptions().setSsl(this.request.ssl).setHost(host).setPort(port).setURI(requestURI));
        } else if (this.request.protocol != null && !this.request.protocol.equals("http") && !this.request.protocol.equals("https")) {
            try {
                URI uri = new URI(this.request.protocol, null, host, port, requestURI, null, null);
                req = this.client.requestAbs(this.request.method, uri.toString());
            }
            catch (URISyntaxException ex) {
                this.fail(ex);
                return;
            }
        } else {
            req = this.client.request(this.request.method, port, host, requestURI);
        }
        if (this.request.virtualHost != null) {
            String virtalHost = this.request.virtualHost;
            if (port != 80) {
                virtalHost = virtalHost + ":" + port;
            }
            req.setHost(virtalHost);
        }
        this.redirects = 0;
        if (this.request.headers != null) {
            req.headers().addAll(this.request.headers);
        }
        this.sendRequest(req);
    }

    private void handleReceiveResponse() {
        HttpClientResponse resp = this.clientResponse;
        Context context = Vertx.currentContext();
        Future fut = Future.future();
        fut.setHandler(r -> context.runOnContext(v -> {
            if (r.succeeded()) {
                this.dispatchResponse((HttpResponse)r.result());
            } else {
                this.fail(r.cause());
            }
        }));
        resp.exceptionHandler(err -> {
            if (!fut.isComplete()) {
                fut.fail(err);
            }
        });
        this.request.codec.create(ar2 -> {
            resp.resume();
            if (ar2.succeeded()) {
                BodyStream stream = (BodyStream)ar2.result();
                stream.exceptionHandler(err -> {
                    if (!fut.isComplete()) {
                        fut.fail(err);
                    }
                });
                resp.endHandler(v -> {
                    if (!fut.isComplete()) {
                        stream.end();
                        if (stream.result().succeeded()) {
                            fut.complete(new HttpResponseImpl<Object>(resp.version(), resp.statusCode(), resp.statusMessage(), resp.headers(), resp.trailers(), resp.cookies(), stream.result().result()));
                        } else {
                            fut.fail(stream.result().cause());
                        }
                    }
                });
                Pump responsePump = Pump.pump((ReadStream)resp, (WriteStream)stream);
                responsePump.start();
            } else {
                this.fail(ar2.cause());
            }
        });
    }

    private void handleSendRequest() {
        Future responseFuture = Future.future().setHandler(ar -> {
            if (ar.succeeded()) {
                HttpClientResponse resp = (HttpClientResponse)ar.result();
                resp.pause();
                this.receiveResponse(resp);
            } else {
                this.fail(ar.cause());
            }
        });
        HttpClientRequest req = this.clientRequest;
        req.handler(arg_0 -> ((Future)responseFuture).tryComplete(arg_0));
        if (this.request.timeout > 0L) {
            req.setTimeout(this.request.timeout);
        }
        if (this.body != null) {
            if (this.contentType != null) {
                String prev = req.headers().get(HttpHeaders.CONTENT_TYPE);
                if (prev == null) {
                    req.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)this.contentType);
                } else {
                    this.contentType = prev;
                }
            }
            if (this.body instanceof MultiMap) {
                MultipartForm parts = MultipartForm.create();
                MultiMap attributes = (MultiMap)this.body;
                for (Map.Entry attribute : attributes) {
                    parts.attribute((String)attribute.getKey(), (String)attribute.getValue());
                }
                this.body = parts;
            }
            if (this.body instanceof MultipartForm) {
                MultipartFormUpload multipartForm;
                try {
                    boolean multipart = "multipart/form-data".equals(this.contentType);
                    multipartForm = new MultipartFormUpload(this.context, (MultipartForm)this.body, multipart);
                    this.body = multipartForm;
                }
                catch (Exception e) {
                    responseFuture.tryFail((Throwable)e);
                    return;
                }
                for (String headerName : this.request.headers().names()) {
                    req.putHeader(headerName, this.request.headers().get(headerName));
                }
                multipartForm.headers().forEach(header -> req.putHeader((String)header.getKey(), (String)header.getValue()));
                multipartForm.run();
            }
            if (this.body instanceof ReadStream) {
                ReadStream stream = (ReadStream)this.body;
                if (this.request.headers == null || !this.request.headers.contains(HttpHeaders.CONTENT_LENGTH)) {
                    req.setChunked(true);
                }
                Pump pump = Pump.pump((ReadStream)stream, (WriteStream)req);
                req.exceptionHandler(err -> {
                    pump.stop();
                    stream.endHandler(null);
                    stream.resume();
                    responseFuture.tryFail(err);
                });
                stream.exceptionHandler(err -> {
                    responseFuture.tryFail(err);
                    req.reset();
                });
                stream.endHandler(v -> {
                    req.exceptionHandler(arg_0 -> ((Future)responseFuture).tryFail(arg_0));
                    req.end();
                    pump.stop();
                });
                pump.start();
                stream.resume();
            } else {
                Buffer buffer = this.body instanceof Buffer ? (Buffer)this.body : (this.body instanceof JsonObject ? Buffer.buffer((String)((JsonObject)this.body).encode()) : Buffer.buffer((String)Json.encode((Object)this.body)));
                req.exceptionHandler(arg_0 -> ((Future)responseFuture).tryFail(arg_0));
                req.end(buffer);
            }
        } else {
            req.exceptionHandler(arg_0 -> ((Future)responseFuture).tryFail(arg_0));
            req.end();
        }
    }

    public <T> T get(String key) {
        return (T)(this.attrs != null ? this.attrs.get(key) : null);
    }

    public HttpContext<T> set(String key, Object value) {
        if (value == null) {
            if (this.attrs != null) {
                this.attrs.remove(key);
            }
        } else {
            if (this.attrs == null) {
                this.attrs = new HashMap<String, Object>();
            }
            this.attrs.put(key, value);
        }
        return this;
    }
}

