/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.command;

import io.vertx.core.AsyncResult;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.sqlclient.impl.TxStatus;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandScheduler;

public abstract class CommandResponse<R>
implements AsyncResult<R> {
    public CommandScheduler scheduler;
    public CommandBase<R> cmd;
    private final TxStatus txStatus;

    public static <R> CommandResponse<R> failure(String msg) {
        return CommandResponse.failure((Throwable)new NoStackTraceThrowable(msg), null);
    }

    public static <R> CommandResponse<R> failure(String msg, TxStatus txStatus) {
        return CommandResponse.failure((Throwable)new NoStackTraceThrowable(msg), txStatus);
    }

    public static <R> CommandResponse<R> failure(Throwable cause) {
        return CommandResponse.failure(cause, null);
    }

    public static <R> CommandResponse<R> failure(final Throwable cause, TxStatus txStatus) {
        return new CommandResponse<R>(txStatus){

            public R result() {
                return null;
            }

            public Throwable cause() {
                return cause;
            }

            public boolean succeeded() {
                return false;
            }

            public boolean failed() {
                return true;
            }
        };
    }

    public static <R> CommandResponse<R> success(R result) {
        return CommandResponse.success(result, null);
    }

    public static <R> CommandResponse<R> success(final R result, TxStatus txStatus) {
        return new CommandResponse<R>(txStatus){

            public R result() {
                return result;
            }

            public Throwable cause() {
                return null;
            }

            public boolean succeeded() {
                return true;
            }

            public boolean failed() {
                return false;
            }
        };
    }

    public CommandResponse(TxStatus txStatus) {
        this.txStatus = txStatus;
    }

    public TxStatus txStatus() {
        return this.txStatus;
    }
}

