/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.Cursor;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.RowStream;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.CursorImpl;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.RowSetImpl;
import io.vertx.sqlclient.impl.RowStreamImpl;
import io.vertx.sqlclient.impl.SqlResultBase;
import io.vertx.sqlclient.impl.SqlResultBuilder;
import io.vertx.sqlclient.impl.SqlResultImpl;
import io.vertx.sqlclient.impl.TupleInternal;
import io.vertx.sqlclient.impl.command.CloseCursorCommand;
import io.vertx.sqlclient.impl.command.CloseStatementCommand;
import io.vertx.sqlclient.impl.command.ExtendedBatchQueryCommand;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collector;

class PreparedQueryImpl
implements PreparedQuery {
    private final Connection conn;
    private final Context context;
    private final PreparedStatement ps;
    private final AtomicBoolean closed = new AtomicBoolean();

    PreparedQueryImpl(Connection conn, Context context, PreparedStatement ps) {
        this.conn = conn;
        this.context = context;
        this.ps = ps;
    }

    @Override
    public PreparedQuery execute(Tuple args, Handler<AsyncResult<RowSet<Row>>> handler) {
        return this.execute((TupleInternal)args, false, RowSetImpl.FACTORY, RowSetImpl.COLLECTOR, handler);
    }

    @Override
    public <R> PreparedQuery execute(Tuple args, Collector<Row, ?, R> collector, Handler<AsyncResult<SqlResult<R>>> handler) {
        return this.execute((TupleInternal)args, true, SqlResultImpl::new, collector, handler);
    }

    private <R1, R2 extends SqlResultBase<R1, R2>, R3 extends SqlResult<R1>> PreparedQuery execute(TupleInternal args, boolean singleton, Function<R1, R2> factory, Collector<Row, ?, R1> collector, Handler<AsyncResult<R3>> handler) {
        SqlResultBuilder<R1, R2, R3> b = new SqlResultBuilder<R1, R2, R3>(factory, handler);
        return this.execute(args, 0, null, false, collector, b, b);
    }

    <A, R> PreparedQuery execute(TupleInternal args, int fetch, String cursorId, boolean suspended, Collector<Row, A, R> collector, QueryResultHandler<R> resultHandler, Handler<AsyncResult<Boolean>> handler) {
        if (this.context == Vertx.currentContext()) {
            String msg = this.ps.prepare(args);
            if (msg != null) {
                handler.handle((Object)Future.failedFuture((String)msg));
            } else {
                ExtendedQueryCommand<R> cmd = new ExtendedQueryCommand<R>(this.ps, args, fetch, cursorId, suspended, collector, resultHandler);
                cmd.handler = handler;
                this.conn.schedule(cmd);
            }
        } else {
            this.context.runOnContext(v -> this.execute(args, fetch, cursorId, suspended, collector, resultHandler, handler));
        }
        return this;
    }

    @Override
    public Cursor cursor(Tuple args) {
        return this.cursor((TupleInternal)args);
    }

    private Cursor cursor(TupleInternal args) {
        String msg = this.ps.prepare(args);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        return new CursorImpl(this, args);
    }

    @Override
    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public PreparedQuery batch(List<Tuple> argsList, Handler<AsyncResult<RowSet<Row>>> handler) {
        return this.batch(argsList, RowSetImpl.FACTORY, RowSetImpl.COLLECTOR, handler);
    }

    @Override
    public <R> PreparedQuery batch(List<Tuple> argsList, Collector<Row, ?, R> collector, Handler<AsyncResult<SqlResult<R>>> handler) {
        return this.batch(argsList, SqlResultImpl::new, collector, handler);
    }

    private <R1, R2 extends SqlResultBase<R1, R2>, R3 extends SqlResult<R1>> PreparedQuery batch(List<Tuple> argsList, Function<R1, R2> factory, Collector<Row, ?, R1> collector, Handler<AsyncResult<R3>> handler) {
        for (Tuple args : argsList) {
            String msg = this.ps.prepare((TupleInternal)args);
            if (msg == null) continue;
            handler.handle((Object)Future.failedFuture((String)msg));
            return this;
        }
        SqlResultBuilder<R1, R2, R3> b = new SqlResultBuilder<R1, R2, R3>(factory, handler);
        ExtendedBatchQueryCommand<R1> cmd = new ExtendedBatchQueryCommand<R1>(this.ps, argsList, collector, b);
        cmd.handler = b;
        this.conn.schedule(cmd);
        return this;
    }

    @Override
    public RowStream<Row> createStream(int fetch, Tuple args) {
        return new RowStreamImpl(this, fetch, args);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        if (this.closed.compareAndSet(false, true)) {
            CloseStatementCommand cmd = new CloseStatementCommand(this.ps);
            cmd.handler = completionHandler;
            this.conn.schedule(cmd);
        } else {
            completionHandler.handle((Object)Future.failedFuture((String)"Already closed"));
        }
    }

    void closeCursor(String cursorId, Handler<AsyncResult<Void>> handler) {
        CloseCursorCommand cmd = new CloseCursorCommand(cursorId, this.ps);
        cmd.handler = handler;
        this.conn.schedule(cmd);
    }
}

