/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionPool;
import io.vertx.sqlclient.impl.SqlClientBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.CommandScheduler;

public abstract class PoolBase<P extends PoolBase<P>>
extends SqlClientBase<P>
implements Pool {
    private final Context context;
    private final ConnectionPool pool;
    private final boolean closeVertx;

    public PoolBase(Context context, boolean closeVertx, PoolOptions options) {
        int maxSize = options.getMaxSize();
        if (maxSize < 1) {
            throw new IllegalArgumentException("Pool max size must be > 0");
        }
        this.context = context;
        this.pool = new ConnectionPool(this::connect, maxSize, options.getMaxWaitQueueSize());
        this.closeVertx = closeVertx;
    }

    public abstract void connect(Handler<AsyncResult<Connection>> var1);

    @Override
    public void getConnection(Handler<AsyncResult<SqlConnection>> handler) {
        Context current = Vertx.currentContext();
        if (current == this.context) {
            this.pool.acquire(new ConnectionWaiter(handler));
        } else {
            this.context.runOnContext(v -> this.getConnection(handler));
        }
    }

    @Override
    public void begin(Handler<AsyncResult<Transaction>> handler) {
        this.getConnection((Handler<AsyncResult<SqlConnection>>)((Handler)ar -> {
            if (ar.succeeded()) {
                SqlConnectionImpl conn = (SqlConnectionImpl)ar.result();
                Transaction tx = conn.begin(true);
                handler.handle((Object)Future.succeededFuture((Object)tx));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }

    @Override
    public <R> void schedule(final CommandBase<R> cmd, final Handler<? super CommandResponse<R>> handler) {
        Context current = Vertx.currentContext();
        if (current == this.context) {
            this.pool.acquire(new CommandWaiter(){

                @Override
                protected void onSuccess(final Connection conn) {
                    cmd.handler = ar -> {
                        ar.scheduler = new CommandScheduler(){

                            @Override
                            public <R> void schedule(CommandBase<R> cmd, Handler<? super CommandResponse<R>> handler) {
                                cmd.handler = cr -> {
                                    cr.scheduler = this;
                                    handler.handle(cr);
                                };
                                conn.schedule(cmd);
                            }
                        };
                        handler.handle(ar);
                    };
                    conn.schedule(cmd);
                    conn.close(this);
                }

                @Override
                protected void onFailure(Throwable cause) {
                    cmd.handler = handler;
                    cmd.fail(cause);
                }
            });
        } else {
            this.context.runOnContext(v -> this.schedule(cmd, handler));
        }
    }

    protected abstract SqlConnectionImpl wrap(Context var1, Connection var2);

    protected void doClose() {
        this.pool.close();
        if (this.closeVertx) {
            this.context.owner().close();
        }
    }

    @Override
    public void close() {
        Context current = Vertx.currentContext();
        if (current == this.context) {
            this.doClose();
        } else {
            this.context.runOnContext(v -> this.doClose());
        }
    }

    private class ConnectionWaiter
    implements Handler<AsyncResult<Connection>> {
        private final Handler<AsyncResult<SqlConnection>> handler;

        private ConnectionWaiter(Handler<AsyncResult<SqlConnection>> handler) {
            this.handler = handler;
        }

        public void handle(AsyncResult<Connection> ar) {
            if (ar.succeeded()) {
                Connection conn = (Connection)ar.result();
                SqlConnectionImpl holder = PoolBase.this.wrap(PoolBase.this.context, conn);
                conn.init(holder);
                this.handler.handle((Object)Future.succeededFuture((Object)holder));
            } else {
                this.handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }
    }

    private abstract class CommandWaiter
    implements Connection.Holder,
    Handler<AsyncResult<Connection>> {
        private CommandWaiter() {
        }

        protected abstract void onSuccess(Connection var1);

        protected abstract void onFailure(Throwable var1);

        @Override
        public void handleNotification(int processId, String channel, String payload) {
        }

        public void handle(AsyncResult<Connection> ar) {
            if (ar.succeeded()) {
                Connection conn = (Connection)ar.result();
                conn.init(this);
                this.onSuccess(conn);
            } else {
                this.onFailure(ar.cause());
            }
        }

        @Override
        public void handleClosed() {
        }

        @Override
        public void handleException(Throwable err) {
        }
    }
}

