/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.sqlclient.SqlConnectOptionsConverter;
import java.util.HashMap;
import java.util.Map;

@DataObject(generateConverter=true)
public abstract class SqlConnectOptions
extends NetClientOptions {
    public static final boolean DEFAULT_CACHE_PREPARED_STATEMENTS = false;
    public static final int DEFAULT_PREPARED_STATEMENT_CACHE_MAX_SIZE = 256;
    public static final int DEFAULT_PREPARED_STATEMENT_CACHE_SQL_LIMIT = 2048;
    private String host;
    private int port;
    private String user;
    private String password;
    private String database;
    private boolean cachePreparedStatements = false;
    private int preparedStatementCacheMaxSize = 256;
    private int preparedStatementCacheSqlLimit = 2048;
    private Map<String, String> properties;

    public SqlConnectOptions() {
        this.init();
    }

    public SqlConnectOptions(JsonObject json) {
        super(json);
        this.init();
        SqlConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public SqlConnectOptions(SqlConnectOptions other) {
        super((NetClientOptions)other);
        this.host = other.host;
        this.port = other.port;
        this.user = other.user;
        this.password = other.password;
        this.database = other.database;
        this.cachePreparedStatements = other.cachePreparedStatements;
        this.preparedStatementCacheMaxSize = other.preparedStatementCacheMaxSize;
        this.preparedStatementCacheSqlLimit = other.preparedStatementCacheSqlLimit;
        this.properties = new HashMap<String, String>(other.properties);
    }

    public String getHost() {
        return this.host;
    }

    public SqlConnectOptions setHost(String host) {
        this.checkParameterNonNull(host, "Host can not be null");
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public SqlConnectOptions setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Port should range in 0-65535");
        }
        this.port = port;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public SqlConnectOptions setUser(String user) {
        this.checkParameterNonNull(this.host, "User account can not be null");
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public SqlConnectOptions setPassword(String password) {
        this.checkParameterNonNull(this.host, "Password can not be null");
        this.password = password;
        return this;
    }

    public String getDatabase() {
        return this.database;
    }

    public SqlConnectOptions setDatabase(String database) {
        this.checkParameterNonNull(this.host, "Database name can not be null");
        this.database = database;
        return this;
    }

    public boolean getCachePreparedStatements() {
        return this.cachePreparedStatements;
    }

    public SqlConnectOptions setCachePreparedStatements(boolean cachePreparedStatements) {
        this.cachePreparedStatements = cachePreparedStatements;
        return this;
    }

    public int getPreparedStatementCacheMaxSize() {
        return this.preparedStatementCacheMaxSize;
    }

    public SqlConnectOptions setPreparedStatementCacheMaxSize(int preparedStatementCacheMaxSize) {
        this.preparedStatementCacheMaxSize = preparedStatementCacheMaxSize;
        return this;
    }

    public int getPreparedStatementCacheSqlLimit() {
        return this.preparedStatementCacheSqlLimit;
    }

    public SqlConnectOptions setPreparedStatementCacheSqlLimit(int preparedStatementCacheSqlLimit) {
        this.preparedStatementCacheSqlLimit = preparedStatementCacheSqlLimit;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public SqlConnectOptions setProperties(Map<String, String> properties) {
        this.checkParameterNonNull(properties, "Properties can not be null");
        this.properties = properties;
        return this;
    }

    public SqlConnectOptions addProperty(String key, String value) {
        this.checkParameterNonNull(key, "Property key can not be null");
        this.checkParameterNonNull(value, "Property value can not be null");
        this.properties.put(key, value);
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        SqlConnectOptionsConverter.toJson(this, json);
        return json;
    }

    protected abstract void init();

    protected void checkParameterNonNull(Object parameter, String message) {
        if (parameter == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

