/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.RowDesc;
import io.vertx.sqlclient.impl.SqlResultBase;
import java.util.function.Function;

public class SqlResultBuilder<T, R extends SqlResultBase<T, R>, L extends SqlResult<T>>
implements QueryResultHandler<T>,
Handler<AsyncResult<Boolean>> {
    private final Handler<AsyncResult<L>> handler;
    private final Function<T, R> factory;
    private R first;
    private boolean suspended;

    SqlResultBuilder(Function<T, R> factory, Handler<AsyncResult<L>> handler) {
        this.factory = factory;
        this.handler = handler;
    }

    @Override
    public void handleResult(int updatedCount, int size, RowDesc desc, T result) {
        SqlResultBase r = (SqlResultBase)this.factory.apply(result);
        r.updated = updatedCount;
        r.size = size;
        r.columnNames = desc != null ? desc.columnNames() : null;
        this.handleResult(r);
    }

    private void handleResult(R result) {
        if (this.first == null) {
            this.first = result;
        } else {
            R h = this.first;
            while (((SqlResultBase)h).next != null) {
                h = ((SqlResultBase)h).next;
            }
            ((SqlResultBase)h).next = result;
        }
    }

    public void handle(AsyncResult<Boolean> res) {
        this.suspended = res.succeeded() && (Boolean)res.result() != false;
        this.handler.handle((Object)res.map(this.first));
    }

    public boolean isSuspended() {
        return this.suspended;
    }
}

