/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.sqlclient.Tuple;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;

public class ArrayTuple
extends ArrayList<Object>
implements Tuple {
    public static Tuple EMPTY = new ArrayTuple(0);

    public ArrayTuple(int len) {
        super(len);
    }

    public ArrayTuple(Collection<?> c) {
        super(c);
    }

    @Override
    public <T> T get(Class<T> type, int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] getValues(Class<T> type, int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean getBoolean(int pos) {
        Object val = this.get(pos);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return null;
    }

    @Override
    public Object getValue(int pos) {
        return this.get(pos);
    }

    @Override
    public Short getShort(int pos) {
        Object val = this.get(pos);
        if (val instanceof Short) {
            return (Short)val;
        }
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        return null;
    }

    @Override
    public Integer getInteger(int pos) {
        Object val = this.get(pos);
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        return null;
    }

    @Override
    public Long getLong(int pos) {
        Object val = this.get(pos);
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return null;
    }

    @Override
    public Float getFloat(int pos) {
        Object val = this.get(pos);
        if (val instanceof Float) {
            return (Float)val;
        }
        if (val instanceof Number) {
            return Float.valueOf(((Number)val).floatValue());
        }
        return null;
    }

    @Override
    public Double getDouble(int pos) {
        Object val = this.get(pos);
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int pos) {
        Object val = this.get(pos);
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof Number) {
            return new BigDecimal(val.toString());
        }
        return null;
    }

    @Override
    public Integer[] getIntegerArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Integer[]) {
            return (Integer[])val;
        }
        return null;
    }

    @Override
    public Boolean[] getBooleanArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Boolean[]) {
            return (Boolean[])val;
        }
        return null;
    }

    @Override
    public Short[] getShortArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Short[]) {
            return (Short[])val;
        }
        return null;
    }

    @Override
    public Long[] getLongArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Long[]) {
            return (Long[])val;
        }
        return null;
    }

    @Override
    public Float[] getFloatArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Float[]) {
            return (Float[])val;
        }
        return null;
    }

    @Override
    public Double[] getDoubleArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Double[]) {
            return (Double[])val;
        }
        return null;
    }

    @Override
    public String[] getStringArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof String[]) {
            return (String[])val;
        }
        return null;
    }

    @Override
    public LocalDate[] getLocalDateArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof LocalDate[]) {
            return (LocalDate[])val;
        }
        return null;
    }

    @Override
    public LocalTime[] getLocalTimeArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof LocalTime[]) {
            return (LocalTime[])val;
        }
        return null;
    }

    @Override
    public OffsetTime[] getOffsetTimeArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof OffsetTime[]) {
            return (OffsetTime[])val;
        }
        return null;
    }

    @Override
    public LocalDateTime[] getLocalDateTimeArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof LocalDateTime[]) {
            return (LocalDateTime[])val;
        }
        return null;
    }

    @Override
    public OffsetDateTime[] getOffsetDateTimeArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof OffsetDateTime[]) {
            return (OffsetDateTime[])val;
        }
        return null;
    }

    @Override
    public Buffer[] getBufferArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Buffer[]) {
            return (Buffer[])val;
        }
        return null;
    }

    @Override
    public UUID[] getUUIDArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof UUID[]) {
            return (UUID[])val;
        }
        return null;
    }

    @Override
    public String getString(int pos) {
        Object val = this.get(pos);
        if (val instanceof String) {
            return (String)val;
        }
        return null;
    }

    @Override
    public Buffer getBuffer(int pos) {
        Object val = this.get(pos);
        if (val instanceof Buffer) {
            return (Buffer)val;
        }
        return null;
    }

    @Override
    public Temporal getTemporal(int pos) {
        Object val = this.get(pos);
        if (val instanceof Temporal) {
            return (Temporal)val;
        }
        return null;
    }

    @Override
    public LocalDate getLocalDate(int pos) {
        Object val = this.get(pos);
        if (val instanceof LocalDate) {
            return (LocalDate)val;
        }
        return null;
    }

    @Override
    public LocalTime getLocalTime(int pos) {
        Object val = this.get(pos);
        if (val instanceof LocalTime) {
            return (LocalTime)val;
        }
        return null;
    }

    @Override
    public LocalDateTime getLocalDateTime(int pos) {
        Object val = this.get(pos);
        if (val instanceof LocalDateTime) {
            return (LocalDateTime)val;
        }
        return null;
    }

    @Override
    public OffsetTime getOffsetTime(int pos) {
        Object val = this.get(pos);
        if (val instanceof OffsetTime) {
            return (OffsetTime)val;
        }
        return null;
    }

    @Override
    public OffsetDateTime getOffsetDateTime(int pos) {
        Object val = this.get(pos);
        if (val instanceof OffsetDateTime) {
            return (OffsetDateTime)val;
        }
        return null;
    }

    @Override
    public UUID getUUID(int pos) {
        Object val = this.get(pos);
        if (val instanceof UUID) {
            return (UUID)val;
        }
        return null;
    }

    @Override
    public Tuple addBoolean(Boolean value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addValue(Object value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addShort(Short value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addInteger(Integer value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addLong(Long value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addFloat(Float value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addDouble(Double value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addString(String value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addBuffer(Buffer value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addTemporal(Temporal value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addLocalDate(LocalDate value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addLocalTime(LocalTime value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addLocalDateTime(LocalDateTime value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addOffsetTime(OffsetTime value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addOffsetDateTime(OffsetDateTime value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addUUID(UUID value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addBigDecimal(BigDecimal value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addIntegerArray(Integer[] value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addBooleanArray(Boolean[] value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addShortArray(Short[] value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addLongArray(Long[] value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addFloatArray(Float[] value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addDoubleArray(Double[] value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addStringArray(String[] value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addLocalDateArray(LocalDate[] value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addLocalTimeArray(LocalTime[] value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addOffsetTimeArray(OffsetTime[] value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addLocalDateTimeArray(LocalDateTime[] value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addOffsetDateTimeArray(OffsetDateTime[] value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addBufferArray(Buffer[] value) {
        this.add(value);
        return this;
    }

    @Override
    public Tuple addUUIDArray(UUID[] value) {
        this.add(value);
        return this;
    }

    @Override
    public <T> Tuple addValues(T[] value) {
        this.add(value);
        return this;
    }
}

