/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.servicediscovery.types;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.redis.RedisClient;
import io.vertx.rxjava.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.Record;
import java.util.function.Function;
import rx.Single;

@RxGen(value=io.vertx.servicediscovery.types.RedisDataSource.class)
public class RedisDataSource {
    public static final TypeArg<RedisDataSource> __TYPE_ARG = new TypeArg(obj -> new RedisDataSource((io.vertx.servicediscovery.types.RedisDataSource)obj), RedisDataSource::getDelegate);
    private final io.vertx.servicediscovery.types.RedisDataSource delegate;

    public RedisDataSource(io.vertx.servicediscovery.types.RedisDataSource delegate) {
        this.delegate = delegate;
    }

    public io.vertx.servicediscovery.types.RedisDataSource getDelegate() {
        return this.delegate;
    }

    public static Record createRecord(String name, JsonObject location, JsonObject metadata) {
        Record ret = io.vertx.servicediscovery.types.RedisDataSource.createRecord(name, location, metadata);
        return ret;
    }

    public static void getRedisClient(ServiceDiscovery discovery, JsonObject filter, final Handler<AsyncResult<RedisClient>> resultHandler) {
        io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), filter, new Handler<AsyncResult<io.vertx.redis.RedisClient>>(){

            public void handle(AsyncResult<io.vertx.redis.RedisClient> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RedisClient.newInstance((io.vertx.redis.RedisClient)((io.vertx.redis.RedisClient)ar.result()))));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public static Single<RedisClient> rxGetRedisClient(ServiceDiscovery discovery, JsonObject filter) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> RedisDataSource.getRedisClient(discovery, filter, (Handler<AsyncResult<RedisClient>>)fut)));
    }

    public static void getRedisClient(ServiceDiscovery discovery, final Function<Record, Boolean> filter, final Handler<AsyncResult<RedisClient>> resultHandler) {
        io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), new Function<Record, Boolean>(){

            @Override
            public Boolean apply(Record arg) {
                Boolean ret = (Boolean)filter.apply(arg);
                return ret;
            }
        }, new Handler<AsyncResult<io.vertx.redis.RedisClient>>(){

            public void handle(AsyncResult<io.vertx.redis.RedisClient> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RedisClient.newInstance((io.vertx.redis.RedisClient)((io.vertx.redis.RedisClient)ar.result()))));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public static Single<RedisClient> rxGetRedisClient(ServiceDiscovery discovery, Function<Record, Boolean> filter) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> RedisDataSource.getRedisClient(discovery, filter, (Handler<AsyncResult<RedisClient>>)fut)));
    }

    public static void getRedisClient(ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration, final Handler<AsyncResult<RedisClient>> resultHandler) {
        io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), filter, consumerConfiguration, new Handler<AsyncResult<io.vertx.redis.RedisClient>>(){

            public void handle(AsyncResult<io.vertx.redis.RedisClient> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RedisClient.newInstance((io.vertx.redis.RedisClient)((io.vertx.redis.RedisClient)ar.result()))));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public static Single<RedisClient> rxGetRedisClient(ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> RedisDataSource.getRedisClient(discovery, filter, consumerConfiguration, (Handler<AsyncResult<RedisClient>>)fut)));
    }

    public static void getRedisClient(ServiceDiscovery discovery, final Function<Record, Boolean> filter, JsonObject consumerConfiguration, final Handler<AsyncResult<RedisClient>> resultHandler) {
        io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), new Function<Record, Boolean>(){

            @Override
            public Boolean apply(Record arg) {
                Boolean ret = (Boolean)filter.apply(arg);
                return ret;
            }
        }, consumerConfiguration, new Handler<AsyncResult<io.vertx.redis.RedisClient>>(){

            public void handle(AsyncResult<io.vertx.redis.RedisClient> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RedisClient.newInstance((io.vertx.redis.RedisClient)((io.vertx.redis.RedisClient)ar.result()))));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public static Single<RedisClient> rxGetRedisClient(ServiceDiscovery discovery, Function<Record, Boolean> filter, JsonObject consumerConfiguration) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> RedisDataSource.getRedisClient(discovery, filter, consumerConfiguration, (Handler<AsyncResult<RedisClient>>)fut)));
    }

    public static RedisDataSource newInstance(io.vertx.servicediscovery.types.RedisDataSource arg) {
        return arg != null ? new RedisDataSource(arg) : null;
    }
}

