/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.rx.java.ContextScheduler;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.ObservableHandler;
import io.vertx.rx.java.ObservableReadStream;
import io.vertx.rx.java.ReadStreamSubscriber;
import io.vertx.rx.java.UnmarshallerOperator;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.impl.WriteStreamSubscriberImpl;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.plugins.RxJavaSchedulersHook;

public class RxHelper {
    public static <T> Subscriber<T> toSubscriber(final Handler<AsyncResult<T>> handler) {
        final AtomicBoolean completed = new AtomicBoolean();
        return new Subscriber<T>(){

            public void onCompleted() {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.succeededFuture());
                }
            }

            public void onError(Throwable error) {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.failedFuture((Throwable)error));
                }
            }

            public void onNext(T item) {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.succeededFuture(item));
                }
            }
        };
    }

    public static <T> ReadStream<T> toReadStream(Observable<T> observable) {
        return ReadStreamSubscriber.asReadStream(observable, Function.identity());
    }

    public static <T> Observable<T> toObservable(ReadStream<T> stream) {
        return RxHelper.toObservable(stream, Function.identity());
    }

    public static <T> Observable<T> toObservable(ReadStream<T> stream, int maxBufferSize) {
        return RxHelper.toObservable(stream, Function.identity(), maxBufferSize);
    }

    public static <T, R> Observable<R> toObservable(ReadStream<T> stream, Function<T, R> adapter) {
        return Observable.create(new ObservableReadStream<T, R>(stream, adapter));
    }

    public static <T, R> Observable<R> toObservable(ReadStream<T> stream, Function<T, R> adapter, int maxBufferSize) {
        return Observable.create(new ObservableReadStream<T, R>(stream, adapter, maxBufferSize));
    }

    public static <T> ObservableFuture<T> observableFuture() {
        return new ObservableFuture();
    }

    public static <T> ObservableHandler<T> observableHandler() {
        return RxHelper.observableHandler(false);
    }

    public static <T> ObservableHandler<T> observableHandler(boolean multi) {
        return new ObservableHandler(multi);
    }

    public static <T> Handler<AsyncResult<T>> toFuture(Observer<T> observer) {
        ObservableFuture<T> observable = RxHelper.observableFuture();
        observable.subscribe(observer);
        return observable.toHandler();
    }

    public static <T> Handler<T> toHandler(Observer<T> observer) {
        return RxHelper.toHandler(observer, false);
    }

    public static <T> Handler<T> toHandler(Observer<T> observer, boolean multi) {
        ObservableHandler<T> observable = RxHelper.observableHandler(multi);
        observable.subscribe(observer);
        return observable.toHandler();
    }

    public static <T> Handler<AsyncResult<T>> toFuture(Action1<T> onNext) {
        ObservableFuture<T> observable = RxHelper.observableFuture();
        observable.subscribe(onNext);
        return observable.toHandler();
    }

    public static <T> Handler<T> toHandler(Action1<T> onNext) {
        ObservableHandler<T> observable = RxHelper.observableHandler(true);
        observable.subscribe(onNext);
        return observable.toHandler();
    }

    public static <T> Handler<AsyncResult<T>> toFuture(Action1<T> onNext, Action1<Throwable> onError) {
        ObservableFuture<T> observable = RxHelper.observableFuture();
        observable.subscribe(onNext, onError);
        return observable.toHandler();
    }

    public static <T> Handler<AsyncResult<T>> toFuture(Action1<T> onNext, Action1<Throwable> onError, Action0 onComplete) {
        ObservableFuture<T> observable = RxHelper.observableFuture();
        observable.subscribe(onNext, onError, onComplete);
        return observable.toHandler();
    }

    public static Scheduler scheduler(Vertx vertx) {
        return new ContextScheduler(vertx, false);
    }

    public static Scheduler scheduler(Context context) {
        return new ContextScheduler(context, false);
    }

    public static Scheduler blockingScheduler(Vertx vertx) {
        return new ContextScheduler(vertx, true);
    }

    public static Scheduler blockingScheduler(Vertx vertx, boolean ordered) {
        return new ContextScheduler(vertx, true, ordered);
    }

    public static RxJavaSchedulersHook schedulerHook(final Context context) {
        return new RxJavaSchedulersHook(){

            public Scheduler getComputationScheduler() {
                return RxHelper.scheduler(context);
            }

            public Scheduler getIOScheduler() {
                return RxHelper.blockingScheduler(context.owner());
            }

            public Scheduler getNewThreadScheduler() {
                return RxHelper.scheduler(context);
            }
        };
    }

    public static RxJavaSchedulersHook schedulerHook(final Vertx vertx) {
        return new RxJavaSchedulersHook(){

            public Scheduler getComputationScheduler() {
                return RxHelper.scheduler(vertx);
            }

            public Scheduler getIOScheduler() {
                return RxHelper.blockingScheduler(vertx);
            }

            public Scheduler getNewThreadScheduler() {
                return RxHelper.scheduler(vertx);
            }
        };
    }

    public static <T> Observable.Operator<T, Buffer> unmarshaller(Class<T> mappedType, ObjectMapper mapper) {
        return new UnmarshallerOperator<T, Buffer>((Class)mappedType, mapper){

            @Override
            public Buffer unwrap(Buffer buffer) {
                return buffer;
            }
        };
    }

    public static <T> Observable.Operator<T, Buffer> unmarshaller(Class<T> mappedType) {
        return new UnmarshallerOperator<T, Buffer>((Class)mappedType){

            @Override
            public Buffer unwrap(Buffer buffer) {
                return buffer;
            }
        };
    }

    public static <T> Observable.Operator<T, Buffer> unmarshaller(TypeReference<T> mappedTypeRef) {
        return new UnmarshallerOperator<T, Buffer>((TypeReference)mappedTypeRef){

            @Override
            public Buffer unwrap(Buffer buffer) {
                return buffer;
            }
        };
    }

    public static <T> Observable.Operator<T, Buffer> unmarshaller(TypeReference<T> mappedTypeRef, ObjectMapper mapper) {
        return new UnmarshallerOperator<T, Buffer>((TypeReference)mappedTypeRef, mapper){

            @Override
            public Buffer unwrap(Buffer buffer) {
                return buffer;
            }
        };
    }

    static void setNullHandlers(ReadStream<?> stream) {
        try {
            stream.exceptionHandler(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stream.endHandler(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stream.handler(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T> WriteStreamSubscriber<T> toSubscriber(WriteStream<T> stream) {
        return RxHelper.toSubscriber(stream, Function.identity());
    }

    public static <R, T> WriteStreamSubscriber<R> toSubscriber(WriteStream<T> stream, Function<R, T> mapping) {
        return new WriteStreamSubscriberImpl<R, T>(stream, mapping);
    }
}

