/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;

public final class Reply {
    private final byte type;
    private final Object data;

    public Reply(byte type, Object data) {
        this.type = type;
        this.data = data;
    }

    public Reply(byte type, int size) {
        this.type = type;
        this.data = new Reply[size];
    }

    void set(int pos, Reply reply) {
        ((Reply[])this.data)[pos] = reply;
    }

    public boolean is(byte b) {
        return this.type == b;
    }

    public boolean is(char b) {
        return this.type == (byte)b;
    }

    byte type() {
        return this.type;
    }

    public Object data() {
        return this.data;
    }

    public <T> T asType(Class<T> type, String encoding) throws ClassCastException {
        if (this.data == null) {
            return null;
        }
        if (type == String.class) {
            if (this.data instanceof String) {
                return (T)this.data;
            }
            if (this.data instanceof Buffer) {
                return (T)((Buffer)this.data).toString(encoding);
            }
            return (T)this.data.toString();
        }
        if (type == Long.class) {
            return (T)this.data;
        }
        if (type == Void.class) {
            return null;
        }
        if (type == Buffer.class) {
            return (T)this.data;
        }
        if (type == JsonArray.class) {
            JsonArray multi = new JsonArray();
            for (Reply r : (Reply[])this.data) {
                Object elem;
                switch (r.type()) {
                    case 36: 
                    case 43: {
                        elem = r.asType(String.class, encoding);
                        break;
                    }
                    case 58: {
                        elem = r.asType(Long.class, encoding);
                        break;
                    }
                    case 42: {
                        elem = r.asType(JsonArray.class, encoding);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown sub message type in multi: " + r.type());
                    }
                }
                if (elem == null) {
                    multi.addNull();
                    continue;
                }
                multi.add(elem);
            }
            return (T)multi;
        }
        if (type == JsonObject.class) {
            JsonObject multi = new JsonObject();
            block11: for (int i = 0; i < ((Reply[])this.data).length; i += 2) {
                if (((Reply[])this.data)[i].type() != 36) {
                    throw new RuntimeException("Expected String as key type in multi: " + ((Reply[])this.data)[i].type());
                }
                Reply brKey = ((Reply[])this.data)[i];
                Reply brValue = ((Reply[])this.data)[i + 1];
                String k = brKey.asType(String.class, encoding);
                switch (brValue.type()) {
                    case 36: {
                        multi.put(k == null ? "k" + i / 2 : k, brValue.asType(String.class, encoding));
                        continue block11;
                    }
                    case 58: {
                        multi.put(k == null ? "k" + i / 2 : k, brValue.asType(Long.class, encoding));
                        continue block11;
                    }
                    case 42: {
                        multi.put(k == null ? "k" + i / 2 : k, brValue.asType(JsonArray.class, encoding));
                        continue block11;
                    }
                    default: {
                        throw new RuntimeException("Unknown sub message type in multi: " + ((Reply[])this.data)[i + 1].type());
                    }
                }
            }
            return (T)multi;
        }
        return null;
    }

    public <T> T asType(Class<T> type) throws ClassCastException {
        return this.asType(type, "UTF-8");
    }
}

