/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.groovy.redis;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ConversionHelper;
import io.vertx.core.json.JsonArray;
import io.vertx.redis.RedisTransaction;
import io.vertx.redis.op.GeoMember;
import io.vertx.redis.op.GeoRadiusOptions;
import io.vertx.redis.op.GeoUnit;
import io.vertx.redis.op.KillFilter;
import io.vertx.redis.op.LimitOptions;
import io.vertx.redis.op.MigrateOptions;
import io.vertx.redis.op.RangeLimitOptions;
import io.vertx.redis.op.ScanOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.redis.op.SortOptions;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RedisTransaction_GroovyExtension {
    public static RedisTransaction clientKill(RedisTransaction j_receiver, Map<String, Object> filter, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.clientKill(filter != null ? new KillFilter(ConversionHelper.toJsonObject(filter)) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction exec(RedisTransaction j_receiver, final Handler<AsyncResult<List<Object>>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.exec(handler != null ? new Handler<AsyncResult<JsonArray>>(){

            public void handle(AsyncResult<JsonArray> ar) {
                handler.handle((Object)ar.map(event -> ConversionHelper.fromJsonArray((JsonArray)event)));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction hmset(RedisTransaction j_receiver, String key, Map<String, Object> values, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.hmset(key, values != null ? ConversionHelper.toJsonObject(values) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction migrate(RedisTransaction j_receiver, String host, int port, String key, int destdb, long timeout, Map<String, Object> options, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.migrate(host, port, key, destdb, timeout, options != null ? new MigrateOptions(ConversionHelper.toJsonObject(options)) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction mset(RedisTransaction j_receiver, Map<String, Object> keyvals, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.mset(keyvals != null ? ConversionHelper.toJsonObject(keyvals) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction msetnx(RedisTransaction j_receiver, Map<String, Object> keyvals, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.msetnx(keyvals != null ? ConversionHelper.toJsonObject(keyvals) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction setWithOptions(RedisTransaction j_receiver, String key, String value, Map<String, Object> options, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.setWithOptions(key, value, options != null ? new SetOptions(ConversionHelper.toJsonObject(options)) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction setBinaryWithOptions(RedisTransaction j_receiver, String key, Buffer value, Map<String, Object> options, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.setBinaryWithOptions(key, value, options != null ? new SetOptions(ConversionHelper.toJsonObject(options)) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction smembers(RedisTransaction j_receiver, String key, final Handler<AsyncResult<List<Object>>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.smembers(key, handler != null ? new Handler<AsyncResult<JsonArray>>(){

            public void handle(AsyncResult<JsonArray> ar) {
                handler.handle((Object)ar.map(event -> ConversionHelper.fromJsonArray((JsonArray)event)));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction sort(RedisTransaction j_receiver, String key, Map<String, Object> options, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.sort(key, options != null ? new SortOptions(ConversionHelper.toJsonObject(options)) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction zrangebylex(RedisTransaction j_receiver, String key, String min, String max, Map<String, Object> options, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.zrangebylex(key, min, max, options != null ? new LimitOptions(ConversionHelper.toJsonObject(options)) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction zrangebyscore(RedisTransaction j_receiver, String key, String min, String max, Map<String, Object> options, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.zrangebyscore(key, min, max, options != null ? new RangeLimitOptions(ConversionHelper.toJsonObject(options)) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction zrevrangebylex(RedisTransaction j_receiver, String key, String max, String min, Map<String, Object> options, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.zrevrangebylex(key, max, min, options != null ? new LimitOptions(ConversionHelper.toJsonObject(options)) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction zrevrangebyscore(RedisTransaction j_receiver, String key, String max, String min, Map<String, Object> options, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.zrevrangebyscore(key, max, min, options != null ? new RangeLimitOptions(ConversionHelper.toJsonObject(options)) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction scan(RedisTransaction j_receiver, String cursor, Map<String, Object> options, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.scan(cursor, options != null ? new ScanOptions(ConversionHelper.toJsonObject(options)) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction sscan(RedisTransaction j_receiver, String key, String cursor, Map<String, Object> options, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.sscan(key, cursor, options != null ? new ScanOptions(ConversionHelper.toJsonObject(options)) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction hscan(RedisTransaction j_receiver, String key, String cursor, Map<String, Object> options, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.hscan(key, cursor, options != null ? new ScanOptions(ConversionHelper.toJsonObject(options)) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction zscan(RedisTransaction j_receiver, String key, String cursor, Map<String, Object> options, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.zscan(key, cursor, options != null ? new ScanOptions(ConversionHelper.toJsonObject(options)) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction geoaddMany(RedisTransaction j_receiver, String key, List<Map<String, Object>> members, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.geoaddMany(key, members != null ? members.stream().map(elt -> elt != null ? new GeoMember(ConversionHelper.toJsonObject((Map)elt)) : null).collect(Collectors.toList()) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction georadiusWithOptions(RedisTransaction j_receiver, String key, double longitude, double latitude, double radius, GeoUnit unit, Map<String, Object> options, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.georadiusWithOptions(key, longitude, latitude, radius, unit, options != null ? new GeoRadiusOptions(ConversionHelper.toJsonObject(options)) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }

    public static RedisTransaction georadiusbymemberWithOptions(RedisTransaction j_receiver, String key, String member, double radius, GeoUnit unit, Map<String, Object> options, final Handler<AsyncResult<String>> handler) {
        ConversionHelper.fromObject((Object)j_receiver.georadiusbymemberWithOptions(key, member, radius, unit, options != null ? new GeoRadiusOptions(ConversionHelper.toJsonObject(options)) : null, handler != null ? new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> ar) {
                handler.handle((Object)ar.map(event -> event));
            }
        } : null));
        return j_receiver;
    }
}

