/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.lang.js;

import io.vertx.codegen.Case;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.Lang;
import io.vertx.codetrans.Script;
import io.vertx.codetrans.lang.js.JavaScriptCodeBuilder;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;

public class JavaScriptLang
implements Lang {
    LinkedHashSet<ClassTypeInfo> modules = new LinkedHashSet();

    @Override
    public String id() {
        return "js";
    }

    @Override
    public CodeBuilder codeBuilder() {
        return new JavaScriptCodeBuilder();
    }

    @Override
    public Script loadScript(ClassLoader loader, String path, String method) throws Exception {
        String name = "src/test/generated/js/".replace('/', File.separatorChar) + Stream.of(path.split("/")).map(f -> Case.SNAKE.format(Case.CAMEL.parse((String)f))).collect(Collectors.joining(File.separator)) + File.separator + Case.SNAKE.format(Case.CAMEL.parse(method)) + ".js";
        File f2 = new File(name);
        final String src = new String(Files.readAllBytes(f2.toPath()));
        ScriptEngineManager mgr = new ScriptEngineManager();
        final ScriptEngine engine = mgr.getEngineByName("nashorn");
        engine.put("__engine", engine);
        InputStream require = this.getClass().getClassLoader().getResourceAsStream("vertx-js/util/require.js");
        if (require == null) {
            throw new Exception("Not require.js");
        }
        engine.put("javax.script.filename", "require.js");
        engine.eval(new InputStreamReader(require));
        engine.eval("var console = require('vertx-js/util/console')");
        return new Script(){

            @Override
            public String getSource() {
                return src;
            }

            @Override
            public void run(Map<String, Object> globals) throws Exception {
                engine.setBindings(new SimpleBindings(globals), 200);
                engine.eval(src);
            }
        };
    }

    @Override
    public String getExtension() {
        return "js";
    }
}

