/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.expression;

import io.vertx.codegen.type.TypeInfo;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.TypeArg;
import io.vertx.codetrans.expression.DataObjectLiteralModel;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.IdentifierModel;
import java.util.List;

public class DataObjectModel
extends ExpressionModel {
    final ExpressionModel expression;

    public DataObjectModel(CodeBuilder builder, ExpressionModel expression) {
        super(builder);
        this.expression = expression;
    }

    @Override
    public ExpressionModel onMethodInvocation(TypeInfo receiverType, MethodSignature method, TypeInfo returnType, List<TypeArg> typeArguments, List<ExpressionModel> argumentModels, List<TypeInfo> argumentTypes) {
        String methodName = method.getName();
        if (DataObjectLiteralModel.isSet(methodName)) {
            return this.builder.render((CodeWriter writer) -> writer.renderDataObjectAssign(this.expression, DataObjectLiteralModel.unwrapSet(methodName), ((ExpressionModel)argumentModels.get(0)).toDataObjectValue()));
        }
        if (DataObjectLiteralModel.isGet(methodName)) {
            return this.builder.render((CodeWriter writer) -> writer.renderDataObjectMemberSelect(this.expression, DataObjectLiteralModel.unwrapSet(methodName)));
        }
        if (this.isToJson(method)) {
            return this.builder.render((CodeWriter writer) -> writer.renderDataObjectToJson((IdentifierModel)this.expression));
        }
        throw new UnsupportedOperationException("Unsupported method " + method + " on object model");
    }

    private boolean isToJson(MethodSignature method) {
        return "toJson".equals(method.getName()) && method.getReturnType().getKind().json && method.getParameterTypes().isEmpty();
    }

    @Override
    public void render(CodeWriter writer) {
        this.expression.render(writer);
    }
}

