/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.ext.auth.PRNG;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.StartTLSOptions;
import io.vertx.ext.mail.impl.ConnectionLifeCycleListener;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.SMTPReset;
import io.vertx.ext.mail.impl.SMTPStarter;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;

class SMTPConnectionPool
implements ConnectionLifeCycleListener {
    private static final Logger log = LoggerFactory.getLogger(SMTPConnectionPool.class);
    private final int maxSockets;
    private final boolean keepAlive;
    private final Queue<Waiter> waiters = new ArrayDeque<Waiter>();
    private final Set<SMTPConnection> allConnections = new HashSet<SMTPConnection>();
    private final NetClient netClient;
    private final MailConfig config;
    private final PRNG prng;
    private String hostname;
    private boolean closed = false;
    private int connCount;
    private Handler<Void> closeFinishedHandler;

    SMTPConnectionPool(Vertx vertx, MailConfig config) {
        this.config = config;
        this.maxSockets = config.getMaxPoolSize();
        this.keepAlive = config.isKeepAlive();
        this.prng = new PRNG(vertx);
        NetClientOptions netClientOptions = new NetClientOptions().setSsl(config.isSsl()).setTrustAll(config.isTrustAll());
        if ((config.isSsl() || config.getStarttls() != StartTLSOptions.DISABLED) && !config.isTrustAll()) {
            netClientOptions.setHostnameVerificationAlgorithm("HTTPS");
        }
        if (config.getKeyStore() != null) {
            netClientOptions.setTrustStoreOptions(new JksOptions().setPath(config.getKeyStore()).setPassword(config.getKeyStorePassword()));
        }
        this.netClient = vertx.createNetClient(netClientOptions);
    }

    void getConnection(String hostname, Handler<AsyncResult<SMTPConnection>> resultHandler) {
        log.debug((Object)"getConnection()");
        this.hostname = hostname;
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((String)"connection pool is closed"));
        } else {
            this.getConnection0(resultHandler);
        }
    }

    void close() {
        this.close(null);
    }

    synchronized void close(Handler<Void> finishedHandler) {
        if (this.closed) {
            throw new IllegalStateException("pool is already closed");
        }
        this.closed = true;
        this.closeFinishedHandler = finishedHandler;
        this.closeAllConnections();
    }

    synchronized int connCount() {
        return this.connCount;
    }

    @Override
    public synchronized void dataEnded(SMTPConnection conn) {
        this.checkReuseConnection(conn);
    }

    @Override
    public synchronized void connectionClosed(SMTPConnection conn) {
        Waiter waiter;
        log.debug((Object)"connection closed, removing from pool");
        --this.connCount;
        if (conn != null) {
            this.allConnections.remove(conn);
        }
        if ((waiter = this.waiters.poll()) != null) {
            log.debug((Object)"creating new connection for waiter");
            this.createNewConnection((Handler<AsyncResult<SMTPConnection>>)waiter.handler);
        }
        if (this.closed && this.connCount == 0) {
            log.debug((Object)"all connections closed, closing NetClient");
            this.netClient.close();
            if (this.closeFinishedHandler != null) {
                this.closeFinishedHandler.handle(null);
            }
        }
    }

    private synchronized void getConnection0(Handler<AsyncResult<SMTPConnection>> handler) {
        SMTPConnection idleConn = null;
        for (SMTPConnection conn : this.allConnections) {
            if (conn.isBroken() || !conn.isIdle()) continue;
            idleConn = conn;
            break;
        }
        if (idleConn == null && this.connCount >= this.maxSockets) {
            log.debug((Object)"waiting for a free socket");
            this.waiters.add(new Waiter(handler));
        } else if (idleConn == null) {
            log.debug((Object)"create a new connection");
            this.createNewConnection(handler);
        } else {
            if (idleConn.isClosed()) {
                log.warn((Object)"idle connection is closed already, this may cause a problem");
            }
            log.debug((Object)"found idle connection, checking");
            SMTPConnection conn = idleConn;
            conn.useConnection();
            conn.getContext().runOnContext(v -> new SMTPReset(conn, (Handler<AsyncResult<Void>>)((Handler)result -> {
                if (result.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)conn));
                } else {
                    conn.setBroken();
                    log.debug((Object)"using idle connection failed, create a new connection");
                    this.createNewConnection(handler);
                }
            })).start());
        }
    }

    private synchronized void checkReuseConnection(SMTPConnection conn) {
        if (conn.isBroken()) {
            log.debug((Object)"connection is broken, closing");
            conn.close();
        } else if (!this.keepAlive || this.closed) {
            log.debug((Object)"connection pool is disabled or pool is already closed, immediately doing QUIT");
            conn.close();
        } else {
            log.debug((Object)"checking for waiting operations");
            Waiter waiter = this.waiters.poll();
            if (waiter != null) {
                log.debug((Object)"running one waiting operation");
                conn.useConnection();
                waiter.handler.handle((Object)Future.succeededFuture((Object)conn));
            } else {
                log.debug((Object)"keeping connection idle");
                conn.setIdle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllConnections() {
        if (this.connCount > 0) {
            HashSet<SMTPConnection> copy;
            SMTPConnectionPool sMTPConnectionPool = this;
            synchronized (sMTPConnectionPool) {
                copy = new HashSet<SMTPConnection>(this.allConnections);
                this.allConnections.clear();
            }
            for (SMTPConnection conn : copy) {
                if (conn.isIdle() || conn.isBroken()) {
                    conn.close();
                    continue;
                }
                log.debug((Object)"closing connection after current send operation finishes");
                conn.setDoShutdown();
            }
        } else if (this.closeFinishedHandler != null) {
            this.closeFinishedHandler.handle(null);
        }
    }

    private void createNewConnection(Handler<AsyncResult<SMTPConnection>> handler) {
        ++this.connCount;
        log.debug((Object)("Connection count is " + this.connCount));
        this.createConnection((Handler<AsyncResult<SMTPConnection>>)((Handler)result -> {
            if (result.succeeded()) {
                this.allConnections.add((SMTPConnection)result.result());
            }
            handler.handle(result);
        }));
    }

    private void createConnection(Handler<AsyncResult<SMTPConnection>> handler) {
        SMTPConnection conn = new SMTPConnection(this.netClient, this);
        new SMTPStarter(conn, this.config, this.hostname, this.prng, (Handler<AsyncResult<Void>>)((Handler)result -> {
            if (result.succeeded()) {
                handler.handle((Object)Future.succeededFuture((Object)conn));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)result.cause()));
            }
        })).start();
    }

    private static class Waiter {
        private final Handler<AsyncResult<SMTPConnection>> handler;

        private Waiter(Handler<AsyncResult<SMTPConnection>> handler) {
            this.handler = handler;
        }
    }
}

