/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner.scanner;

import io.vertx.lang.groovy.fastclasspathscanner.matchprocessor.FileMatchContentsProcessor;
import io.vertx.lang.groovy.fastclasspathscanner.matchprocessor.FileMatchContentsProcessorWithContext;
import io.vertx.lang.groovy.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.vertx.lang.groovy.fastclasspathscanner.matchprocessor.FileMatchProcessorWithContext;
import io.vertx.lang.groovy.fastclasspathscanner.matchprocessor.FilenameMatchProcessor;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.matchers.FileMatchProcessorAny;
import io.vertx.lang.groovy.fastclasspathscanner.utils.ClasspathUtils;
import io.vertx.lang.groovy.fastclasspathscanner.utils.FileUtils;
import io.vertx.lang.groovy.fastclasspathscanner.utils.LogNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public abstract class ClasspathResource {
    public final File classpathEltFile;
    public final String pathRelativeToClasspathElt;
    public final String pathRelativeToClasspathPrefix;
    public long inputStreamLength;

    protected ClasspathResource(File classpathEltFile, String pathRelativeToClasspathElt, String pathRelativeToClasspathPrefix) {
        this.classpathEltFile = classpathEltFile;
        this.pathRelativeToClasspathElt = pathRelativeToClasspathElt;
        this.pathRelativeToClasspathPrefix = pathRelativeToClasspathPrefix;
    }

    public String toString() {
        return ClasspathUtils.getClasspathResourceURL(this.classpathEltFile, this.pathRelativeToClasspathElt).toString();
    }

    public abstract InputStream open() throws IOException;

    public long getInputStreamLength() {
        return this.inputStreamLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFileMatch(FileMatchProcessorAny fileMatchProcessor, LogNode log) throws IOException {
        if (fileMatchProcessor instanceof FilenameMatchProcessor) {
            ((FilenameMatchProcessor)fileMatchProcessor).processMatch(this.classpathEltFile, this.pathRelativeToClasspathPrefix);
        } else if (fileMatchProcessor instanceof FileMatchProcessor) {
            try {
                ((FileMatchProcessor)fileMatchProcessor).processMatch(this.pathRelativeToClasspathPrefix, this.open(), this.inputStreamLength);
            }
            finally {
                this.close();
            }
        } else if (fileMatchProcessor instanceof FileMatchProcessorWithContext) {
            try {
                ((FileMatchProcessorWithContext)fileMatchProcessor).processMatch(this.classpathEltFile, this.pathRelativeToClasspathPrefix, this.open(), this.inputStreamLength);
            }
            finally {
                this.close();
            }
        } else if (fileMatchProcessor instanceof FileMatchContentsProcessor) {
            try {
                ((FileMatchContentsProcessor)fileMatchProcessor).processMatch(this.pathRelativeToClasspathPrefix, FileUtils.readAllBytes(this.open(), this.inputStreamLength, log));
            }
            finally {
                this.close();
            }
        } else if (fileMatchProcessor instanceof FileMatchContentsProcessorWithContext) {
            try {
                ((FileMatchContentsProcessorWithContext)fileMatchProcessor).processMatch(this.classpathEltFile, this.pathRelativeToClasspathPrefix, FileUtils.readAllBytes(this.open(), this.inputStreamLength, log));
            }
            finally {
                this.close();
            }
        } else {
            throw new RuntimeException("Unknown FileMatchProcessor type " + fileMatchProcessor.getClass().getName());
        }
    }

    public abstract void close();
}

