/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan.impl;

import io.vertx.core.net.impl.ServerID;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;

@SerializeWith(value=InfinispanServerIDExternalizer.class)
public class InfinispanServerID {
    private final ServerID serverID;

    public InfinispanServerID(ServerID serverID) {
        Objects.requireNonNull(serverID);
        this.serverID = serverID;
    }

    public ServerID getServerID() {
        return this.serverID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfinispanServerID that = (InfinispanServerID)o;
        return this.serverID.equals((Object)that.serverID);
    }

    public int hashCode() {
        return this.serverID.hashCode();
    }

    public static class InfinispanServerIDExternalizer
    implements Externalizer<InfinispanServerID> {
        public void writeObject(ObjectOutput output, InfinispanServerID object) throws IOException {
            output.writeInt(((InfinispanServerID)object).serverID.port);
            output.writeUTF(((InfinispanServerID)object).serverID.host);
        }

        public InfinispanServerID readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            ServerID serverID = new ServerID(input.readInt(), input.readUTF());
            return new InfinispanServerID(serverID);
        }
    }
}

