/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;

@SerializeWith(value=ClusterSerializableExternalizer.class)
public class InfinispanClusterSerializable {
    private final ClusterSerializable data;

    public InfinispanClusterSerializable(ClusterSerializable data) {
        Objects.requireNonNull(data);
        this.data = data;
    }

    public ClusterSerializable getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfinispanClusterSerializable that = (InfinispanClusterSerializable)o;
        return this.data.equals(that.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public static class ClusterSerializableExternalizer
    implements Externalizer<InfinispanClusterSerializable> {
        public void writeObject(ObjectOutput output, InfinispanClusterSerializable object) throws IOException {
            output.writeUTF(object.data.getClass().getName());
            Buffer buffer = Buffer.buffer();
            object.data.writeToBuffer(buffer);
            byte[] bytes = buffer.getBytes();
            output.writeInt(bytes.length);
            output.write(bytes);
        }

        public InfinispanClusterSerializable readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            ClusterSerializable clusterSerializable;
            String className = input.readUTF();
            int length = input.readInt();
            byte[] bytes = new byte[length];
            input.readFully(bytes);
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            try {
                clusterSerializable = (ClusterSerializable)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            clusterSerializable.readFromBuffer(0, Buffer.buffer((byte[])bytes));
            return new InfinispanClusterSerializable(clusterSerializable);
        }
    }
}

