/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan.impl;

import io.vertx.core.eventbus.impl.clustered.ClusterNodeInfo;
import io.vertx.core.net.impl.ServerID;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;

@SerializeWith(value=InfinispanClusterNodeInfoExternalizer.class)
public class InfinispanClusterNodeInfo {
    private final ClusterNodeInfo clusterNodeInfo;

    public InfinispanClusterNodeInfo(ClusterNodeInfo clusterNodeInfo) {
        Objects.requireNonNull(clusterNodeInfo);
        this.clusterNodeInfo = clusterNodeInfo;
    }

    public ClusterNodeInfo getClusterNodeInfo() {
        return this.clusterNodeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfinispanClusterNodeInfo that = (InfinispanClusterNodeInfo)o;
        return this.clusterNodeInfo.equals((Object)that.clusterNodeInfo);
    }

    public int hashCode() {
        return this.clusterNodeInfo.hashCode();
    }

    public static class InfinispanClusterNodeInfoExternalizer
    implements Externalizer<InfinispanClusterNodeInfo> {
        public void writeObject(ObjectOutput output, InfinispanClusterNodeInfo object) throws IOException {
            output.writeUTF(((InfinispanClusterNodeInfo)object).clusterNodeInfo.nodeId);
            output.writeInt(((InfinispanClusterNodeInfo)object).clusterNodeInfo.serverID.port);
            output.writeUTF(((InfinispanClusterNodeInfo)object).clusterNodeInfo.serverID.host);
        }

        public InfinispanClusterNodeInfo readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            ClusterNodeInfo clusterNodeInfo = new ClusterNodeInfo(input.readUTF(), new ServerID(input.readInt(), input.readUTF()));
            return new InfinispanClusterNodeInfo(clusterNodeInfo);
        }
    }
}

