/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.dropwizard.ThroughputMeter;
import io.vertx.ext.dropwizard.ThroughputTimer;
import io.vertx.ext.dropwizard.impl.Matcher;
import io.vertx.ext.dropwizard.impl.RequestMetric;
import io.vertx.ext.dropwizard.impl.TCPMetricsImpl;
import io.vertx.ext.dropwizard.impl.WebSocketMetric;
import java.util.EnumMap;
import java.util.concurrent.TimeUnit;

abstract class HttpMetricsImpl
extends TCPMetricsImpl {
    private ThroughputTimer requests;
    private ThroughputMeter[] responses;
    private final Counter openWebSockets = this.counter("open-websockets");
    private EnumMap<HttpMethod, ThroughputTimer> methodRequests;

    public HttpMetricsImpl(MetricRegistry registry, String baseName, SocketAddress localAddress) {
        super(registry, baseName);
        this.requests = this.throughputTimer("requests");
        this.responses = new ThroughputMeter[]{this.throughputMeter("responses-1xx"), this.throughputMeter("responses-2xx"), this.throughputMeter("responses-3xx"), this.throughputMeter("responses-4xx"), this.throughputMeter("responses-5xx")};
        this.methodRequests = new EnumMap(HttpMethod.class);
        for (HttpMethod method : HttpMethod.values()) {
            this.methodRequests.put(method, this.throughputTimer(method.toString().toLowerCase() + "-requests"));
        }
    }

    protected WebSocketMetric createWebSocketMetric() {
        this.openWebSockets.inc();
        return null;
    }

    protected long end(RequestMetric metric, int statusCode, Matcher matcher) {
        if (this.closed) {
            return 0L;
        }
        String match = null;
        if (metric.uri != null) {
            match = matcher.matches(metric.uri);
        }
        long duration = System.nanoTime() - metric.requestBegin;
        int responseStatus = statusCode / 100;
        if (responseStatus >= 1 && responseStatus <= 5) {
            this.responses[responseStatus - 1].mark();
        }
        this.requests.update(duration, TimeUnit.NANOSECONDS);
        if (metric.method != null) {
            this.methodRequests.get(metric.method).update(duration, TimeUnit.NANOSECONDS);
            if (match != null) {
                this.throughputTimer(metric.method.toString().toLowerCase() + "-requests", match).update(duration, TimeUnit.NANOSECONDS);
            }
        } else if (match != null) {
            this.throughputTimer("requests", match).update(duration, TimeUnit.NANOSECONDS);
        }
        return duration;
    }

    protected void disconnect(WebSocketMetric metric) {
        if (this.closed) {
            return;
        }
        this.openWebSockets.dec();
    }
}

