/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;

public class HttpConfigStore
implements ConfigStore {
    private final String host;
    private final int port;
    private final String path;
    private final HttpClient client;

    public HttpConfigStore(String host, int port, String path, HttpClient client) {
        this.host = host;
        this.port = port;
        this.path = path;
        this.client = client;
    }

    @Override
    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        this.client.get(this.port, this.host, this.path, response -> response.exceptionHandler(t -> completionHandler.handle((Object)Future.failedFuture((Throwable)t))).bodyHandler(buffer -> completionHandler.handle((Object)Future.succeededFuture((Object)buffer)))).exceptionHandler(t -> completionHandler.handle((Object)Future.failedFuture((Throwable)t))).end();
    }

    @Override
    public void close(Handler<Void> completionHandler) {
        this.client.close();
        completionHandler.handle(null);
    }
}

