/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;

public class EventBusConfigStore
implements ConfigStore {
    private final MessageConsumer<Object> consumer;
    private Buffer last;

    public EventBusConfigStore(Vertx vertx, String address) {
        this.consumer = vertx.eventBus().consumer(address);
        this.consumer.handler(message -> {
            Object body = message.body();
            EventBusConfigStore eventBusConfigStore = this;
            synchronized (eventBusConfigStore) {
                if (body instanceof JsonObject) {
                    this.last = Buffer.buffer((String)((JsonObject)body).encode());
                } else if (body instanceof Buffer) {
                    this.last = (Buffer)body;
                }
            }
        });
    }

    @Override
    public void close(Handler<Void> completionHandler) {
        this.consumer.unregister(ar -> completionHandler.handle(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        Buffer buffer;
        EventBusConfigStore eventBusConfigStore = this;
        synchronized (eventBusConfigStore) {
            buffer = this.last;
        }
        if (buffer != null) {
            completionHandler.handle((Object)Future.succeededFuture((Object)buffer));
        } else {
            completionHandler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)"{}")));
        }
    }
}

