/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl;

import io.vertx.config.ConfigChange;
import io.vertx.config.ConfigRetriever;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.config.impl.ConfigurationProvider;
import io.vertx.config.spi.ConfigProcessor;
import io.vertx.config.spi.ConfigStore;
import io.vertx.config.spi.ConfigStoreFactory;
import io.vertx.config.spi.utils.Processors;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.streams.ReadStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public class ConfigRetrieverImpl
implements ConfigRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigRetrieverImpl.class);
    private final Vertx vertx;
    private final List<ConfigurationProvider> providers;
    private long scan;
    private final List<Handler<ConfigChange>> listeners = new ArrayList<Handler<ConfigChange>>();
    private final ConfigStreamImpl streamOfConfiguration = new ConfigStreamImpl();
    private final ConfigRetrieverOptions options;
    private JsonObject current = new JsonObject();

    public ConfigRetrieverImpl(Vertx vertx, ConfigRetrieverOptions options) {
        this.vertx = vertx;
        this.options = options;
        ServiceLoader<ConfigStoreFactory> storeImpl = ServiceLoader.load(ConfigStoreFactory.class, ConfigStoreFactory.class.getClassLoader());
        HashMap nameToImplMap = new HashMap();
        storeImpl.iterator().forEachRemaining(factory -> nameToImplMap.put(factory.name(), factory));
        if (nameToImplMap.isEmpty()) {
            throw new IllegalStateException("No configuration store implementations found on the classpath");
        }
        this.providers = new ArrayList<ConfigurationProvider>();
        for (ConfigStoreOptions option : options.getStores()) {
            String type = option.getType();
            if (type == null) {
                throw new IllegalArgumentException("the `type` entry is mandatory in a configuration store configuration");
            }
            ConfigStoreFactory factory2 = (ConfigStoreFactory)nameToImplMap.get(type);
            if (factory2 == null) {
                throw new IllegalArgumentException("unknown configuration store implementation: " + type + " (known implementations are: " + nameToImplMap.keySet() + ")");
            }
            JsonObject config = option.getConfig();
            if (config == null) {
                config = new JsonObject();
            }
            ConfigStore store = factory2.create(vertx, config);
            String format = option.getFormat() != null ? option.getFormat() : "json";
            ConfigProcessor processor = Processors.get(format);
            if (processor == null) {
                throw new IllegalArgumentException("unknown configuration format: " + format + " (supported formats are: " + Processors.getSupportedFormats());
            }
            this.providers.add(new ConfigurationProvider(store, processor, option.getConfig()));
        }
        this.getConfig((Handler<AsyncResult<JsonObject>>)((Handler)x -> {}));
    }

    public synchronized void initializePeriodicScan() {
        this.scan = this.options.getScanPeriod() > 0L ? this.vertx.setPeriodic(this.options.getScanPeriod(), l -> this.scan()) : -1L;
    }

    @Override
    public void getConfig(Handler<AsyncResult<JsonObject>> completionHandler) {
        Objects.requireNonNull(completionHandler);
        this.compute((Handler<AsyncResult<JsonObject>>)((Handler)ar -> {
            if (ar.succeeded()) {
                ConfigRetrieverImpl configRetrieverImpl = this;
                synchronized (configRetrieverImpl) {
                    this.current = (JsonObject)ar.result();
                    this.streamOfConfiguration.handle(this.current);
                }
            }
            completionHandler.handle(ar);
        }));
    }

    @Override
    public synchronized void close() {
        if (this.scan != -1L) {
            this.vertx.cancelTimer(this.scan);
        }
        this.streamOfConfiguration.close();
        for (ConfigurationProvider provider : this.providers) {
            provider.close((Handler<Void>)((Handler)v -> {}));
        }
    }

    @Override
    public synchronized JsonObject getCachedConfig() {
        return this.current.copy();
    }

    @Override
    public void listen(Handler<ConfigChange> listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    @Override
    public ReadStream<JsonObject> configStream() {
        return this.streamOfConfiguration;
    }

    private void scan() {
        this.compute((Handler<AsyncResult<JsonObject>>)((Handler)ar -> {
            if (ar.failed()) {
                this.streamOfConfiguration.fail(ar.cause());
                LOGGER.error((Object)"Error while scanning configuration", ar.cause());
            } else {
                ConfigRetrieverImpl configRetrieverImpl = this;
                synchronized (configRetrieverImpl) {
                    if (!this.current.equals(ar.result())) {
                        JsonObject prev = this.current;
                        this.current = (JsonObject)ar.result();
                        this.listeners.forEach(l -> l.handle((Object)new ConfigChange(prev, this.current)));
                        this.streamOfConfiguration.handle(this.current);
                    }
                }
            }
        }));
    }

    private void compute(Handler<AsyncResult<JsonObject>> completionHandler) {
        List futures = this.providers.stream().map(s -> {
            Future conf = Future.future();
            s.get(this.vertx, (Handler<AsyncResult<JsonObject>>)((Handler)ar -> {
                if (ar.succeeded()) {
                    conf.complete(ar.result());
                } else {
                    conf.fail(ar.cause());
                }
            }));
            return conf;
        }).collect(Collectors.toList());
        CompositeFuture.all(futures).setHandler(r -> {
            if (r.failed()) {
                completionHandler.handle((Object)Future.failedFuture((Throwable)r.cause()));
            } else {
                JsonObject json = new JsonObject();
                futures.forEach(future -> json.mergeIn((JsonObject)future.result()));
                completionHandler.handle((Object)Future.succeededFuture((Object)json));
            }
        });
    }

    private class ConfigStreamImpl
    implements ReadStream<JsonObject> {
        private Handler<JsonObject> handler;
        private Handler<Throwable> exceptionHandler;
        private Handler<Void> endHandler;
        private JsonObject last;
        private boolean paused = false;

        private ConfigStreamImpl() {
        }

        public synchronized ReadStream<JsonObject> exceptionHandler(Handler<Throwable> handler) {
            Objects.requireNonNull(handler);
            this.exceptionHandler = handler;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ReadStream<JsonObject> handler(Handler<JsonObject> handler) {
            JsonObject conf;
            Objects.requireNonNull(handler);
            ConfigStreamImpl configStreamImpl = this;
            synchronized (configStreamImpl) {
                this.handler = handler;
                conf = ConfigRetrieverImpl.this.getCachedConfig();
            }
            if (conf != null && !conf.isEmpty()) {
                ConfigRetrieverImpl.this.vertx.runOnContext(v -> this.handler.handle((Object)conf));
            }
            return this;
        }

        public synchronized ReadStream<JsonObject> pause() {
            this.paused = true;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ReadStream<JsonObject> resume() {
            Handler<JsonObject> succ;
            JsonObject conf;
            ConfigStreamImpl configStreamImpl = this;
            synchronized (configStreamImpl) {
                if (!this.paused) {
                    return this;
                }
                this.paused = false;
                conf = this.last;
                if (this.last != null) {
                    this.last = null;
                }
                succ = this.handler;
            }
            if (conf != null && succ != null) {
                ConfigRetrieverImpl.this.vertx.runOnContext(v -> succ.handle((Object)conf));
            }
            return this;
        }

        public synchronized ReadStream<JsonObject> endHandler(Handler<Void> endHandler) {
            Objects.requireNonNull(endHandler);
            this.endHandler = endHandler;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handle(JsonObject conf) {
            boolean isPaused;
            Handler<JsonObject> succ;
            ConfigStreamImpl configStreamImpl = this;
            synchronized (configStreamImpl) {
                succ = this.handler;
                isPaused = this.paused;
                if (this.paused) {
                    this.last = conf;
                }
            }
            if (!isPaused && succ != null) {
                ConfigRetrieverImpl.this.vertx.runOnContext(v -> succ.handle((Object)conf));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fail(Throwable cause) {
            Handler<Throwable> err;
            ConfigStreamImpl configStreamImpl = this;
            synchronized (configStreamImpl) {
                err = this.exceptionHandler;
            }
            if (err != null) {
                ConfigRetrieverImpl.this.vertx.runOnContext(v -> err.handle((Object)cause));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Handler<Void> handler;
            ConfigStreamImpl configStreamImpl = this;
            synchronized (configStreamImpl) {
                handler = this.endHandler;
            }
            if (handler != null) {
                ConfigRetrieverImpl.this.vertx.runOnContext(v -> handler.handle(null));
            }
        }
    }
}

