/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.expression;

import io.vertx.codetrans.expression.ExpressionModel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class Member {
    final String name;

    public Member(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static class Entries
    extends Member {
        Map<String, List<ExpressionModel>> entries = new LinkedHashMap<String, List<ExpressionModel>>();

        public Entries(String name) {
            super(name);
        }

        protected Member append(String key, ExpressionModel value) {
            this.entries.computeIfAbsent(key, k -> new ArrayList()).add(value);
            return this;
        }

        public Iterable<Member> entries() {
            ArrayList<Member> members = new ArrayList<Member>();
            this.entries.forEach((k, v) -> {
                if (v.size() == 1) {
                    members.add(new Single((String)k).append((ExpressionModel)v.get(0)));
                } else {
                    members.add(new Sequence((String)k).append((List<ExpressionModel>)v));
                }
            });
            return members;
        }
    }

    public static class Sequence
    extends Member {
        List<ExpressionModel> values = new ArrayList<ExpressionModel>();

        public Sequence(String name) {
            super(name);
        }

        public List<ExpressionModel> getValues() {
            return this.values;
        }

        protected Member append(ExpressionModel value) {
            this.values.add(value);
            return this;
        }

        protected Member append(List<ExpressionModel> value) {
            this.values.addAll(value);
            return this;
        }
    }

    public static class Single
    extends Member {
        ExpressionModel value;

        public Single(String name) {
            super(name);
        }

        public ExpressionModel getValue() {
            return this.value;
        }

        protected Member append(ExpressionModel value) {
            this.value = value;
            return this;
        }
    }
}

