/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.jwt.JWT;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.impl.AccessTokenImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.flow.AuthCodeImpl;
import io.vertx.ext.auth.oauth2.impl.flow.AuthJWTImpl;
import io.vertx.ext.auth.oauth2.impl.flow.ClientImpl;
import io.vertx.ext.auth.oauth2.impl.flow.OAuth2Flow;
import io.vertx.ext.auth.oauth2.impl.flow.PasswordImpl;

public class OAuth2AuthProviderImpl
implements OAuth2Auth {
    private final Vertx vertx;
    private final OAuth2ClientOptions config;
    private final JWT jwt;
    private final OAuth2Flow flow;

    public OAuth2AuthProviderImpl(Vertx vertx, OAuth2FlowType flow, OAuth2ClientOptions config) {
        this.vertx = vertx;
        this.config = config;
        switch (flow) {
            case AUTH_CODE: {
                this.jwt = new JWT(config.getPublicKey(), false);
                this.flow = new AuthCodeImpl(this);
                break;
            }
            case CLIENT: {
                this.jwt = new JWT(config.getPublicKey(), false);
                this.flow = new ClientImpl(this);
                break;
            }
            case PASSWORD: {
                this.jwt = new JWT(config.getPublicKey(), false);
                this.flow = new PasswordImpl(this);
                break;
            }
            case AUTH_JWT: {
                this.jwt = new JWT(config.getPrivateKey(), true);
                this.flow = new AuthJWTImpl(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid oauth2 flow type: " + (Object)((Object)flow));
            }
        }
    }

    public OAuth2ClientOptions getConfig() {
        return this.config;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    JsonObject decode(String token) {
        return this.jwt.decode(token);
    }

    public String sign(JsonObject payload) {
        return this.jwt.sign(payload, this.config.getExtraParameters());
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        resultHandler.handle((Object)Future.failedFuture((String)"JWT cannot be used for AuthN"));
    }

    @Override
    public String authorizeURL(JsonObject params) {
        return this.flow.authorizeURL(params);
    }

    @Override
    public void getToken(JsonObject params, Handler<AsyncResult<AccessToken>> handler) {
        this.flow.getToken(params, handler);
    }

    @Override
    public OAuth2Auth api(HttpMethod method, String path, JsonObject params, Handler<AsyncResult<JsonObject>> handler) {
        OAuth2API.api(this, method, path, params, handler);
        return this;
    }

    @Override
    public boolean hasJWTToken() {
        return this.config.isJwtToken();
    }

    @Override
    public OAuth2Auth decodeToken(String token, Handler<AsyncResult<AccessToken>> handler) {
        if (!this.config.isJwtToken()) {
            handler.handle((Object)Future.failedFuture((String)"Provider does not support JWT tokens"));
        } else {
            try {
                handler.handle((Object)Future.succeededFuture((Object)new AccessTokenImpl(this, new JsonObject().put("access_token", token))));
            }
            catch (RuntimeException e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
            }
        }
        return this;
    }

    @Override
    public OAuth2Auth introspectToken(String token, Handler<AsyncResult<AccessToken>> handler) {
        return this.introspectToken(token, null, (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                return;
            }
            JsonObject json = (JsonObject)res.result();
            try {
                AccessTokenImpl accessToken = new AccessTokenImpl(this, new JsonObject().put("access_token", token).mergeIn(json));
                if (accessToken.expired()) {
                    handler.handle((Object)Future.failedFuture((String)"Expired token"));
                    return;
                }
                handler.handle((Object)Future.succeededFuture((Object)accessToken));
            }
            catch (RuntimeException e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
            }
        }));
    }

    @Override
    public OAuth2Auth introspectToken(String token, String tokenType, Handler<AsyncResult<JsonObject>> handler) {
        this.flow.introspectToken(token, tokenType, handler);
        return this;
    }

    @Override
    public String getScopeSeparator() {
        String sep = this.config.getScopeSeparator();
        return sep == null ? " " : sep;
    }
}

