/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jdbc.impl;

import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.ext.auth.jdbc.JDBCHashStrategy;
import io.vertx.ext.auth.jdbc.impl.AbstractHashingStrategy;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PBKDF2Strategy
extends AbstractHashingStrategy
implements JDBCHashStrategy {
    private static final int DEFAULT_ITERATIONS = 10000;
    private final SecretKeyFactory skf;

    public PBKDF2Strategy(Vertx vertx) {
        super(vertx);
        try {
            this.skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("PBKDF2 is not available", nsae);
        }
    }

    @Override
    public String computeHash(String password, String salt, int version) {
        int iterations = 10000;
        if (version >= 0) {
            if (this.nonces == null) {
                throw new VertxException("nonces are not available");
            }
            if (version < this.nonces.size()) {
                iterations = this.nonces.getInteger(version);
            }
        }
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(StandardCharsets.UTF_8), iterations, 512);
        try {
            byte[] hash = this.skf.generateSecret(spec).getEncoded();
            if (version >= 0) {
                return this.bytesToHex(hash) + '$' + version;
            }
            return this.bytesToHex(hash);
        }
        catch (InvalidKeySpecException ikse) {
            throw new VertxException((Throwable)ikse);
        }
    }
}

