/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class Exclusions {
    private final Map<String, Set<String>> exclusionsByDependency = new HashMap<String, Set<String>>();

    Exclusions() {
    }

    void add(String dependency, Collection<String> exclusionsForDependency) {
        Set<String> exclusions = this.exclusionsByDependency.get(dependency);
        if (exclusions == null) {
            exclusions = new HashSet<String>();
            this.exclusionsByDependency.put(dependency, exclusions);
        }
        exclusions.addAll(exclusionsForDependency);
    }

    void addAll(Exclusions exclusions) {
        for (Map.Entry<String, Set<String>> entry : exclusions.exclusionsByDependency.entrySet()) {
            this.add(entry.getKey(), (Collection<String>)entry.getValue());
        }
    }

    Set<String> exclusionsForDependency(String dependency) {
        return this.exclusionsByDependency.get(dependency);
    }

    public String toString() {
        return this.exclusionsByDependency.toString();
    }
}

