/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.rule;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.shardingsphere.core.exception.ShardingConfigurationException;
import io.shardingsphere.core.rule.TableRule;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class BindingTableRule {
    private final List<TableRule> tableRules;

    public boolean hasLogicTable(String logicTableName) {
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equals(logicTableName.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public String getBindingActualTable(String dataSource, String logicTable, String otherActualTable) {
        TableRule each2;
        int index = -1;
        Iterator<TableRule> iterator = this.tableRules.iterator();
        while (iterator.hasNext() && -1 == (index = (each2 = iterator.next()).findActualTableIndex(dataSource, otherActualTable))) {
        }
        if (-1 == index) {
            throw new ShardingConfigurationException("Actual table [%s].[%s] is not in table config", dataSource, otherActualTable);
        }
        for (TableRule each2 : this.tableRules) {
            if (!each2.getLogicTable().equals(logicTable.toLowerCase())) continue;
            return each2.getActualDataNodes().get(index).getTableName().toLowerCase();
        }
        throw new ShardingConfigurationException("Cannot find binding actual table, data source: %s, logic table: %s, other actual table: %s", dataSource, logicTable, otherActualTable);
    }

    Collection<String> getAllLogicTables() {
        return Lists.transform(this.tableRules, (Function)new Function<TableRule, String>(){

            public String apply(TableRule input) {
                return input.getLogicTable().toLowerCase();
            }
        });
    }

    @ConstructorProperties(value={"tableRules"})
    public BindingTableRule(List<TableRule> tableRules) {
        this.tableRules = tableRules;
    }

    public List<TableRule> getTableRules() {
        return this.tableRules;
    }
}

